/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;

public class ComponentAdditions {
    private Set<ProcessGroup> processGroups;
    private Set<RemoteProcessGroup> remoteProcessGroups;
    private Set<ProcessorNode> processors;
    private Set<Port> inputPorts;
    private Set<Port> outputPorts;
    private Set<Connection> connections;
    private Set<Label> labels;
    private Set<Funnel> funnels;
    private Set<ControllerServiceNode> controllerServices;

    private ComponentAdditions(Builder builder) {
        this.processGroups = Collections.unmodifiableSet(builder.processGroups);
        this.remoteProcessGroups = Collections.unmodifiableSet(builder.remoteProcessGroups);
        this.processors = Collections.unmodifiableSet(builder.processors);
        this.inputPorts = Collections.unmodifiableSet(builder.inputPorts);
        this.outputPorts = Collections.unmodifiableSet(builder.outputPorts);
        this.connections = Collections.unmodifiableSet(builder.connections);
        this.labels = Collections.unmodifiableSet(builder.labels);
        this.funnels = Collections.unmodifiableSet(builder.funnels);
        this.controllerServices = Collections.unmodifiableSet(builder.controllerServices);
    }

    public Set<ProcessGroup> getProcessGroups() {
        return this.processGroups;
    }

    public Set<RemoteProcessGroup> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public Set<ProcessorNode> getProcessors() {
        return this.processors;
    }

    public Set<Port> getInputPorts() {
        return this.inputPorts;
    }

    public Set<Port> getOutputPorts() {
        return this.outputPorts;
    }

    public Set<Connection> getConnections() {
        return this.connections;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public Set<Funnel> getFunnels() {
        return this.funnels;
    }

    public Set<ControllerServiceNode> getControllerServices() {
        return this.controllerServices;
    }

    public static class Builder {
        private Set<ProcessGroup> processGroups = new HashSet<ProcessGroup>();
        private Set<RemoteProcessGroup> remoteProcessGroups = new HashSet<RemoteProcessGroup>();
        private Set<ProcessorNode> processors = new HashSet<ProcessorNode>();
        private Set<Port> inputPorts = new HashSet<Port>();
        private Set<Port> outputPorts = new HashSet<Port>();
        private Set<Connection> connections = new HashSet<Connection>();
        private Set<Label> labels = new HashSet<Label>();
        private Set<Funnel> funnels = new HashSet<Funnel>();
        private Set<ControllerServiceNode> controllerServices = new HashSet<ControllerServiceNode>();

        public Builder addProcessGroup(ProcessGroup processGroup) {
            this.processGroups.add(processGroup);
            return this;
        }

        public Builder addRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
            this.remoteProcessGroups.add(remoteProcessGroup);
            return this;
        }

        public Builder addProcessor(ProcessorNode processor) {
            this.processors.add(processor);
            return this;
        }

        public Builder addInputPort(Port inputPort) {
            this.inputPorts.add(inputPort);
            return this;
        }

        public Builder addOutputPort(Port outputPort) {
            this.outputPorts.add(outputPort);
            return this;
        }

        public Builder addConnection(Connection connection) {
            this.connections.add(connection);
            return this;
        }

        public Builder addLabel(Label label) {
            this.labels.add(label);
            return this;
        }

        public Builder addFunnel(Funnel funnel) {
            this.funnels.add(funnel);
            return this;
        }

        public Builder addControllerService(ControllerServiceNode controllerService) {
            this.controllerServices.add(controllerService);
            return this;
        }

        public ComponentAdditions build() {
            return new ComponentAdditions(this);
        }
    }
}

