/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.Project;

public class ConcreteClassGenerator {
    public static <T> Constructor<T> getConcreteConstructor(Class<T> abstractClass, Class<?> ... argTypes) throws ClassNotFoundException {
        Class<T> cls = ConcreteClassGenerator.makeConcrete(abstractClass);
        Constructor<?>[] constructors = cls.getConstructors();
        int args = argTypes == null ? 0 : argTypes.length;
        for (Constructor<?> cons : constructors) {
            Class<?>[] params = cons.getParameterTypes();
            if (params.length != args) continue;
            boolean match = false;
            for (int i = 0; i < params.length && (match = params[i].isAssignableFrom(argTypes[i])); ++i) {
            }
            if (!match) continue;
            return cons;
        }
        throw new RuntimeException(abstractClass + " has no constructor with " + (args == 0 ? "void" : Arrays.toString(argTypes)));
    }

    public static <T> Class<? extends T> makeConcrete(Class<T> abstractClass) throws ClassNotFoundException {
        if (abstractClass == null) {
            return null;
        }
        if (!Modifier.isAbstract(abstractClass.getModifiers())) {
            return abstractClass;
        }
        Project project = new Project();
        BCClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction(project, abstractClass.getClassLoader()));
        String name = abstractClass.getName() + "_";
        BCClass bc = AccessController.doPrivileged(J2DoPrivHelper.loadProjectClassAction(project, name));
        bc.setSuperclass(abstractClass);
        Constructor<?>[] constructors = abstractClass.getConstructors();
        if (constructors == null || constructors.length == 0) {
            bc.addDefaultConstructor().makePublic();
        } else {
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> con = constructors[i];
                Class[] args = con.getParameterTypes();
                BCMethod bccon = bc.declareMethod("<init>", Void.TYPE, args);
                Code code = bccon.getCode(true);
                code.xload().setThis();
                for (int j = 0; j < args.length; ++j) {
                    code.aload().setParam(j);
                    code.checkcast().setType(args[j]);
                }
                code.invokespecial().setMethod(abstractClass, "<init>", Void.TYPE, args);
                code.vreturn();
                code.calculateMaxStack();
                code.calculateMaxLocals();
            }
        }
        Class<?> cls = Class.forName(bc.getName(), false, (ClassLoader)loader);
        return cls;
    }

    public static <T> T newInstance(Constructor<T> cons, Object ... params) {
        try {
            return cons.newInstance(params);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static <T> T newInstance(Class<T> c, Class<?>[] paramTypes, Object[] params) {
        try {
            return c.getConstructor(paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static <T> T newInstance(Class<T> c) {
        return ConcreteClassGenerator.newInstance(c, new Class[0], new Object[0]);
    }

    public static <T, P> T newInstance(Class<T> c, Class<? extends P> paramType, P param) {
        return ConcreteClassGenerator.newInstance(c, new Class[]{paramType}, new Object[]{param});
    }

    public static <T, P1, P2> T newInstance(Class<T> c, Class<? extends P1> paramType1, P1 param1, Class<? extends P2> paramType2, P2 param2) {
        return ConcreteClassGenerator.newInstance(c, new Class[]{paramType1, paramType2}, new Object[]{param1, param2});
    }

    public static <T, P1, P2, P3> T newInstance(Class<T> c, Class<? extends P1> paramType1, P1 param1, Class<? extends P2> paramType2, P2 param2, Class<? extends P3> paramType3, P3 param3) {
        return ConcreteClassGenerator.newInstance(c, new Class[]{paramType1, paramType2, paramType3}, new Object[]{param1, param2, param3});
    }

    public static <T, P1, P2, P3, P4> T newInstance(Class<T> c, Class<? extends P1> paramType1, P1 param1, Class<? extends P2> paramType2, P2 param2, Class<? extends P3> paramType3, P3 param3, Class<? extends P4> paramType4, P4 param4) {
        return ConcreteClassGenerator.newInstance(c, new Class[]{paramType1, paramType2, paramType3, paramType4}, new Object[]{param1, param2, param3, param4});
    }
}

