/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.XMLPersistenceMetaDataSerializer;
import org.xml.sax.SAXException;
import serp.util.Strings;

public class XMLPersistenceMappingSerializer
extends XMLPersistenceMetaDataSerializer {
    private static final int TYPE_RESULTMAP = 21;
    private static final Map<ColType, String> _names = new EnumMap<ColType, String>(ColType.class);
    private List<QueryResultMapping> _results = null;
    private boolean _sync = false;

    public XMLPersistenceMappingSerializer(JDBCConfiguration conf) {
        super(conf);
    }

    public boolean getSyncMappingInfo() {
        return this._sync;
    }

    public void setSyncMappingInfo(boolean sync) {
        this._sync = sync;
    }

    public void addQueryResultMapping(QueryResultMapping meta) {
        if (this._results == null) {
            this._results = new ArrayList<QueryResultMapping>();
        }
        this._results.add(meta);
    }

    public boolean removeQueryResultMapping(QueryResultMapping meta) {
        return this._results != null && this._results.remove(meta);
    }

    @Override
    public void addAll(MetaDataRepository repos) {
        super.addAll(repos);
        for (QueryResultMapping res : ((MappingRepository)repos).getQueryResultMappings()) {
            this.addQueryResultMapping(res);
        }
    }

    @Override
    public boolean removeAll(MetaDataRepository repos) {
        boolean removed = super.removeAll(repos);
        for (QueryResultMapping res : ((MappingRepository)repos).getQueryResultMappings()) {
            removed |= this.removeQueryResultMapping(res);
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        if (this._results != null) {
            this._results.clear();
        }
    }

    protected void addCommments(Object obj) throws SAXException {
        if (this.isMappingMode() && !this.isMetaDataMode()) {
            if (obj instanceof ClassMapping) {
                obj = ((ClassMapping)obj).getMappingInfo();
            } else if (obj instanceof FieldMapping) {
                obj = ((FieldMapping)obj).getMappingInfo();
            }
        }
        super.addComments(obj);
    }

    @Override
    protected void serializeClass(ClassMetaData meta, boolean access) throws SAXException {
        ClassMapping cls;
        if (this._sync && this.isMappingMode() && meta instanceof ClassMapping && ((cls = (ClassMapping)meta).getResolve() & 2) != 0 && cls.isMapped()) {
            cls.syncMappingInfo();
            cls.getDiscriminator().syncMappingInfo();
            cls.getVersion().syncMappingInfo();
            FieldMapping[] fields = cls.getEmbeddingMetaData() == null ? cls.getDefinedFieldMappings() : cls.getFieldMappings();
            for (FieldMapping f : fields) {
                f.syncMappingInfo();
            }
        }
        super.serializeClass(meta, access);
    }

    @Override
    protected void serializeClassMappingContent(ClassMetaData mapping) throws SAXException {
        ClassMapping cls = (ClassMapping)mapping;
        ClassMappingInfo info = cls.getMappingInfo();
        this.serializeTable(info.getTableName(), "table", Strings.getClassName(mapping.getDescribedType()), null, info.getUniques(info.getTableName()));
        for (String second : info.getSecondaryTableNames()) {
            this.serializeTable(second, "secondary-table", null, info, info.getUniques(second));
        }
        this.serializeColumns(info, ColType.PK_JOIN, null);
    }

    @Override
    protected void serializeInheritanceContent(ClassMetaData mapping) throws SAXException {
        ClassMapping cls = (ClassMapping)mapping;
        ClassMappingInfo info = cls.getMappingInfo();
        DiscriminatorMappingInfo dinfo = cls.getDiscriminator().getMappingInfo();
        String strat = info.getHierarchyStrategy();
        if ("flat".equals(strat)) {
            this.addAttribute("strategy", "SINGLE_TABLE");
        } else if ("vertical".equals(strat)) {
            this.addAttribute("strategy", "JOINED");
        } else if ("full".equals(strat)) {
            this.addAttribute("strategy", "TABLE_PER_CLASS");
        }
        if (strat != null) {
            this.startElement("inheritance");
            this.endElement("inheritance");
        }
        if (dinfo.getValue() != null) {
            this.startElement("discriminator-value");
            this.addText(dinfo.getValue());
            this.endElement("discriminator-value");
        }
        this.serializeColumns(dinfo, ColType.DISC, null);
    }

    private void serializeTable(String table, String elementName, String defaultName, ClassMappingInfo secondaryInfo, Unique[] uniques) throws SAXException {
        boolean print;
        List<Column> cols = null;
        if (secondaryInfo != null) {
            cols = secondaryInfo.getSecondaryTableJoinColumns(table);
        }
        boolean bl = print = cols != null && cols.size() > 0 || uniques != null && uniques.length > 0;
        if (!(table == null || defaultName != null && defaultName.equals(table))) {
            print = true;
            int index = table.indexOf(46);
            if (index < 0) {
                this.addAttribute("name", table);
            } else {
                Map<String, ClassMetaData> classMetaData = this.getClassMetaData();
                Object[] keySet = null;
                if (classMetaData != null) {
                    keySet = classMetaData.keySet().toArray();
                }
                if (keySet != null && keySet.length > 0 && classMetaData.get(keySet[0]).getUseSchemaElement()) {
                    this.addAttribute("schema", table.substring(0, index));
                }
                this.addAttribute("name", table.substring(index + 1));
            }
        }
        if (print) {
            this.startElement(elementName);
            if (cols != null) {
                for (Column col : cols) {
                    this.serializeColumn(col, ColType.PK_JOIN, null, false);
                }
            }
            if (uniques != null) {
                for (Unique unique : uniques) {
                    this.serializeUniqueConstraint(unique);
                }
            }
            this.endElement(elementName);
        }
    }

    @Override
    protected boolean serializeAttributeOverride(FieldMetaData fmd, FieldMetaData orig) {
        if (orig == null || fmd == orig) {
            return false;
        }
        FieldMapping field = (FieldMapping)fmd;
        FieldMapping field2 = (FieldMapping)orig;
        if (field.getMappingInfo().hasSchemaComponents() || field2.getMappingInfo().hasSchemaComponents()) {
            return true;
        }
        ValueMappingInfo info = field.getValueInfo();
        List<Column> cols = info.getColumns();
        if (cols == null || cols.size() == 0) {
            return false;
        }
        ValueMappingInfo info2 = field2.getValueInfo();
        List<Column> cols2 = info2.getColumns();
        if (cols2 == null || cols2.size() != cols.size()) {
            return true;
        }
        if (cols.size() != 1) {
            return true;
        }
        for (int i = 0; i < cols.size(); ++i) {
            Column col = cols.get(i);
            Column col2 = cols2.get(i);
            if (!StringUtils.equals((String)col.getName(), (String)col2.getName())) {
                return true;
            }
            if (!StringUtils.equals((String)col.getTypeName(), (String)col2.getTypeName())) {
                return true;
            }
            if (col.getSize() != col2.getSize()) {
                return true;
            }
            if (col.getDecimalDigits() != col2.getDecimalDigits()) {
                return true;
            }
            if (col.getFlag(2) != col2.getFlag(2)) {
                return true;
            }
            if (col.getFlag(4) == col2.getFlag(4)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void serializeAttributeOverrideMappingContent(FieldMetaData fmd, FieldMetaData orig) throws SAXException {
        FieldMapping fm = (FieldMapping)fmd;
        this.serializeColumns(fm.getValueInfo(), ColType.COL, fm.getMappingInfo().getTableName());
    }

    @Override
    protected PersistenceStrategy getStrategy(FieldMetaData fmd) {
        PersistenceStrategy strat = super.getStrategy(fmd);
        FieldMapping field = (FieldMapping)fmd;
        switch (strat) {
            case MANY_MANY: {
                if (field.getMappedBy() != null || field.getMappingInfo().getJoinDirection() != 0 && field.getElementMapping().getValueInfo().getUnique() == null) break;
                return PersistenceStrategy.ONE_MANY;
            }
            case MANY_ONE: {
                if (field.getValueInfo().getJoinDirection() == 2 || field.getValueInfo().getUnique() != null) {
                    return PersistenceStrategy.ONE_ONE;
                }
                List<Column> cols = field.getValueInfo().getColumns();
                boolean pkJoin = cols != null && cols.size() > 0;
                for (int i = 0; pkJoin && i < cols.size(); ++i) {
                    pkJoin = cols.get(i).getFlag(128);
                }
                if (!pkJoin) break;
                return PersistenceStrategy.ONE_ONE;
            }
        }
        return strat;
    }

    @Override
    protected void serializeFieldMappingContent(FieldMetaData fmd, PersistenceStrategy strategy) throws SAXException {
        EnumType enumType;
        TemporalType temporal;
        if (fmd.getMappedBy() != null) {
            return;
        }
        FieldMapping field = (FieldMapping)fmd;
        switch (strategy) {
            case MANY_ONE: 
            case ONE_ONE: {
                this.serializeColumns(field.getValueInfo(), ColType.JOIN, field.getMappingInfo().getTableName());
                return;
            }
            case ONE_MANY: {
                if (field.getMappingInfo().getJoinDirection() == 0) {
                    this.serializeColumns(field.getElementMapping().getValueInfo(), ColType.JOIN, null);
                    return;
                }
            }
            case MANY_MANY: {
                if (field.getMappingInfo().hasSchemaComponents() || field.getElementMapping().getValueInfo().hasSchemaComponents()) {
                    String table = field.getMappingInfo().getTableName();
                    if (table != null) {
                        int index = table.indexOf(46);
                        if (index < 0) {
                            this.addAttribute("name", table);
                        } else {
                            this.addAttribute("schema", table.substring(0, index));
                            this.addAttribute("name", table.substring(index + 1));
                        }
                    }
                    this.startElement("join-table");
                    this.serializeColumns(field.getMappingInfo(), ColType.JOIN, null);
                    this.serializeColumns(field.getElementMapping().getValueInfo(), ColType.INVERSE, null);
                    this.endElement("join-table");
                }
                return;
            }
            case ELEM_COLL: {
                if (field.getMappingInfo().hasSchemaComponents() || field.getElementMapping().getValueInfo().hasSchemaComponents()) {
                    String table = field.getMappingInfo().getTableName();
                    if (table != null) {
                        int index = table.indexOf(46);
                        if (index < 0) {
                            this.addAttribute("name", table);
                        } else {
                            this.addAttribute("schema", table.substring(0, index));
                            this.addAttribute("name", table.substring(index + 1));
                        }
                    }
                    this.startElement("collection-table");
                    ValueMappingImpl elem = (ValueMappingImpl)field.getElement();
                    this.serializeColumns(elem.getValueInfo(), ColType.COL, null);
                    this.endElement("collection-table");
                }
                return;
            }
        }
        this.serializeColumns(field.getValueInfo(), ColType.COL, field.getMappingInfo().getTableName());
        if (strategy == PersistenceStrategy.BASIC && this.isLob(field)) {
            this.startElement("lob");
            this.endElement("lob");
        }
        if ((temporal = this.getTemporal(field)) != null) {
            this.startElement("temporal");
            this.addText(temporal.toString());
            this.endElement("temporal");
        }
        if ((enumType = this.getEnumType(field)) != null && enumType != EnumType.ORDINAL) {
            this.startElement("enumerated");
            this.addText(enumType.toString());
            this.endElement("enumerated");
        }
    }

    @Override
    protected void serializeOrderColumn(FieldMetaData fmd) throws SAXException {
        FieldMapping field = (FieldMapping)fmd;
        Column orderCol = field.getOrderColumn();
        if (orderCol != null) {
            if (orderCol.getName() != null) {
                this.addAttribute("name", orderCol.getName());
            }
            if (orderCol.isNotNull()) {
                this.addAttribute("nullable", "false");
            }
            if (orderCol.getFlag(2)) {
                this.addAttribute("insertable", "false");
            }
            if (orderCol.getFlag(4)) {
                this.addAttribute("updatable", "false");
            }
            if (orderCol.getTypeName() != null) {
                this.addAttribute("column-definition", orderCol.getTypeName());
            }
            this.startElement("order-column");
            this.endElement("order-column");
        }
    }

    private boolean isLob(FieldMapping field) {
        for (Column col : field.getValueInfo().getColumns()) {
            if (col.getType() != 2004 && col.getType() != 2005) continue;
            return true;
        }
        return false;
    }

    private TemporalType getTemporal(FieldMapping field) {
        if (field.getDeclaredTypeCode() != 14 && field.getDeclaredTypeCode() != 28) {
            return null;
        }
        DBDictionary dict = ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance();
        int def = dict.getJDBCType(field.getTypeCode(), false);
        for (Column col : field.getValueInfo().getColumns()) {
            if (col.getType() == def) continue;
            switch (col.getType()) {
                case 91: {
                    return TemporalType.DATE;
                }
                case 92: {
                    return TemporalType.TIME;
                }
                case 93: {
                    return TemporalType.TIMESTAMP;
                }
            }
        }
        return null;
    }

    protected EnumType getEnumType(FieldMapping field) {
        if (field.getDeclaredTypeCode() != 8) {
            return null;
        }
        if (!(field.getHandler() instanceof EnumValueHandler)) {
            return null;
        }
        return ((EnumValueHandler)field.getHandler()).getStoreOrdinal() ? EnumType.ORDINAL : EnumType.STRING;
    }

    private void serializeColumns(MappingInfo info, ColType type, String secondary) throws SAXException {
        List<Column> cols = info.getColumns();
        if (cols == null) {
            return;
        }
        for (Column col : cols) {
            this.serializeColumn(col, type, secondary, info.getUnique() != null);
        }
    }

    private void serializeColumn(Column col, ColType type, String secondary, boolean unique) throws SAXException {
        if (col.getName() != null) {
            this.addAttribute("name", col.getName());
        }
        if (col.getTypeName() != null) {
            this.addAttribute("column-definition", col.getTypeName());
        }
        if (col.getTarget() != null && (type == ColType.JOIN || type == ColType.INVERSE || type == ColType.PK_JOIN)) {
            this.addAttribute("referenced-column-name", col.getTarget());
        }
        if (type == ColType.COL || type == ColType.JOIN || type == ColType.PK_JOIN) {
            if (unique) {
                this.addAttribute("unique", "true");
            }
            if (col.isNotNull()) {
                this.addAttribute("nullable", "false");
            }
            if (col.getFlag(2)) {
                this.addAttribute("insertable", "false");
            }
            if (col.getFlag(4)) {
                this.addAttribute("updatable", "false");
            }
            if (secondary != null) {
                this.addAttribute("table", secondary);
            }
            if (type == ColType.COL) {
                if (col.getSize() > 0 && col.getSize() != 255) {
                    this.addAttribute("length", col.getSize() + "");
                }
                if (col.getDecimalDigits() != 0) {
                    this.addAttribute("scale", col.getDecimalDigits() + "");
                }
            }
        }
        if (type != ColType.COL || this.getAttributes().getLength() > 0) {
            String name = col.getFlag(128) ? _names.get((Object)ColType.PK_JOIN) : _names.get((Object)type);
            this.startElement(name);
            this.endElement(name);
        }
    }

    private void serializeUniqueConstraint(Unique unique) throws SAXException {
        Column[] columns;
        if (StringUtils.isNotEmpty((String)unique.getName())) {
            this.addAttribute("name", unique.getName());
        }
        this.startElement("unique-constraint");
        for (Column column : columns = unique.getColumns()) {
            this.startElement("column-name");
            this.addText(column.getName());
            this.endElement("column-name");
        }
        this.endElement("unique-constraint");
    }

    @Override
    protected XMLPersistenceMetaDataSerializer.SerializationComparator newSerializationComparator() {
        return new MappingSerializationComparator();
    }

    @Override
    protected void addSystemMappingElements(Collection toSerialize) {
        if (this.isQueryMode()) {
            toSerialize.addAll(this.getQueryResultMappings(null));
        }
    }

    @Override
    protected int type(Object o) {
        int type = super.type(o);
        if (type == -1 && o instanceof QueryResultMapping) {
            return 21;
        }
        return type;
    }

    private List<QueryResultMapping> getQueryResultMappings(ClassMetaData cm) {
        if (this._results == null || this._results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<QueryResultMapping> result = null;
        for (int i = 0; i < this._results.size(); ++i) {
            QueryResultMapping element = this._results.get(i);
            if (cm == null && element.getSourceScope() != null || cm != null && element.getSourceScope() != cm.getDescribedType()) continue;
            if (result == null) {
                result = new ArrayList<QueryResultMapping>(this._results.size() - i);
            }
            result.add(element);
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    @Override
    protected void serializeSystemMappingElement(Object obj) throws SAXException {
        if (obj instanceof QueryResultMapping) {
            this.serializeQueryResultMapping((QueryResultMapping)obj);
        }
    }

    @Override
    protected void serializeQueryMappings(ClassMetaData meta) throws SAXException {
        for (QueryResultMapping res : this.getQueryResultMappings(meta)) {
            this.serializeQueryResultMapping(res);
        }
    }

    private void serializeQueryResultMapping(QueryResultMapping meta) throws SAXException {
        if (!this.getSerializeAnnotations()) {
            if (meta.getSourceType() == 1) {
                return;
            }
        }
        this.addAttribute("name", meta.getName());
        this.startElement("sql-result-set-mapping");
        for (QueryResultMapping.PCResult pc : meta.getPCResults()) {
            this.addAttribute("entity-class", pc.getCandidateType().getName());
            Object discrim = pc.getMapping("<discriminator>");
            if (discrim != null) {
                this.addAttribute("discriminator-column", discrim.toString());
            }
            this.startElement("entity-result");
            for (String path : pc.getMappingPaths()) {
                this.addAttribute("name", path);
                this.addAttribute("column", pc.getMapping(path).toString());
                this.startElement("field-result");
                this.endElement("field-result");
            }
            this.endElement("entity-result");
        }
        for (Object col : meta.getColumnResults()) {
            this.addAttribute("name", col.toString());
            this.startElement("column-result");
            this.endElement("column-result");
        }
        this.endElement("sql-result-set-mapping");
    }

    @Override
    protected void serializeSequence(SequenceMetaData meta) throws SAXException {
        if (!this.getSerializeAnnotations()) {
            if (meta.getSourceType() == 1) {
                return;
            }
        }
        if ("value-table".equals(meta.getSequencePlugin())) {
            super.serializeSequence(meta);
            return;
        }
        SequenceMapping seq = (SequenceMapping)meta;
        this.addAttribute("name", seq.getName());
        String table = seq.getTable();
        if (table != null) {
            int dotIdx = table.indexOf(46);
            if (dotIdx == -1) {
                this.addAttribute("table", table);
            } else {
                this.addAttribute("table", table.substring(dotIdx + 1));
                this.addAttribute("schema", table.substring(0, dotIdx));
            }
        }
        if (!StringUtils.isEmpty((String)seq.getPrimaryKeyColumn())) {
            this.addAttribute("pk-column-name", seq.getPrimaryKeyColumn());
        }
        if (!StringUtils.isEmpty((String)seq.getSequenceColumn())) {
            this.addAttribute("value-column-name", seq.getSequenceColumn());
        }
        if (!StringUtils.isEmpty((String)seq.getPrimaryKeyValue())) {
            this.addAttribute("pk-column-value", seq.getPrimaryKeyValue());
        }
        if (seq.getAllocate() != 50 && seq.getAllocate() != -1) {
            this.addAttribute("allocation-size", seq.getAllocate() + "");
        }
        if (seq.getInitialValue() != 0 && seq.getInitialValue() != -1) {
            this.addAttribute("initial-value", seq.getInitialValue() + "");
        }
        this.startElement("table-generator");
        this.endElement("table-generator");
    }

    static {
        _names.put(ColType.COL, "column");
        _names.put(ColType.JOIN, "join-column");
        _names.put(ColType.INVERSE, "inverse-join-column");
        _names.put(ColType.PK_JOIN, "primary-key-join-column");
        _names.put(ColType.DISC, "discriminator-column");
    }

    protected class MappingSerializationComparator
    extends XMLPersistenceMetaDataSerializer.SerializationComparator {
        protected MappingSerializationComparator() {
        }

        @Override
        protected int compareUnknown(Object o1, Object o2) {
            int listingIndex2;
            if (!(o1 instanceof QueryResultMapping)) {
                return super.compareUnknown(o1, o2);
            }
            QueryResultMapping res1 = (QueryResultMapping)o1;
            QueryResultMapping res2 = (QueryResultMapping)o2;
            Object scope1 = res1.getSourceScope();
            Object scope2 = res2.getSourceScope();
            if (scope1 == null && scope2 != null) {
                return -1;
            }
            if (scope1 != null && scope2 == null) {
                return 1;
            }
            int listingIndex1 = res1.getListingIndex();
            if (listingIndex1 != (listingIndex2 = res2.getListingIndex())) {
                return listingIndex1 - listingIndex2;
            }
            return res1.getName().compareTo(res2.getName());
        }
    }

    private static enum ColType {
        COL,
        JOIN,
        INVERSE,
        PK_JOIN,
        DISC;

    }
}

