/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.sql.BooleanRepresentation;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class BooleanRepresentationFactory {
    public static BooleanRepresentation INT_10 = new Int10BooleanRepresentation();
    public static BooleanRepresentation BOOLEAN = new BooleanBooleanRepresentation();
    static final Map<String, BooleanRepresentation<?>> BUILTIN_BOOLEAN_REPRESENTATIONS = new HashMap();

    public static BooleanRepresentation valueOf(String booleanRepresentationKey, ClassLoader cl) {
        BooleanRepresentation booleanRepresentation = BUILTIN_BOOLEAN_REPRESENTATIONS.get(booleanRepresentationKey);
        if (booleanRepresentation == null && booleanRepresentationKey.contains("/")) {
            String[] vals = booleanRepresentationKey.split("/");
            if (vals.length == 2) {
                booleanRepresentation = new StringBooleanRepresentation(vals[0], vals[1]);
            }
        } else {
            try {
                Class<?> booleanRepresentationClass = cl.loadClass(booleanRepresentationKey);
                booleanRepresentation = (BooleanRepresentation)booleanRepresentationClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (booleanRepresentation == null) {
            Localizer _loc = Localizer.forPackage(BooleanRepresentation.class);
            throw new UserException(_loc.get("unknown-booleanRepresentation", new Object[]{booleanRepresentationKey, Arrays.toString(BUILTIN_BOOLEAN_REPRESENTATIONS.keySet().toArray(new String[0]))}));
        }
        return booleanRepresentation;
    }

    static {
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("BOOLEAN", BOOLEAN);
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("INT_10", INT_10);
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("STRING_10", new StringBooleanRepresentation("1", "0"));
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("STRING_YN", new StringBooleanRepresentation("Y", "N"));
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("STRING_YN_LOWERCASE", new StringBooleanRepresentation("y", "n"));
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("STRING_TF", new StringBooleanRepresentation("T", "F"));
        BUILTIN_BOOLEAN_REPRESENTATIONS.put("STRING_TF_LOWERCASE", new StringBooleanRepresentation("t", "f"));
    }

    public static class Int10BooleanRepresentation
    implements BooleanRepresentation<Integer> {
        @Override
        public void setBoolean(PreparedStatement stmnt, int idx, boolean val) throws SQLException {
            stmnt.setInt(idx, val ? 1 : 0);
        }

        @Override
        public boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getInt(columnIndex) > 0;
        }

        @Override
        public Integer getRepresentation(boolean bool) {
            return bool ? 1 : 0;
        }

        public String toString() {
            return "Int10BooleanRepresentation";
        }
    }

    public static class BooleanBooleanRepresentation
    implements BooleanRepresentation<Boolean> {
        @Override
        public void setBoolean(PreparedStatement stmnt, int idx, boolean val) throws SQLException {
            stmnt.setBoolean(idx, val);
        }

        @Override
        public boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBoolean(columnIndex);
        }

        @Override
        public Boolean getRepresentation(boolean bool) {
            return bool;
        }

        public String toString() {
            return "BooleanBooleanRepresentation";
        }
    }

    public static class StringBooleanRepresentation
    implements BooleanRepresentation<String> {
        private final String trueRepresentation;
        private final String falseRepresentation;

        public StringBooleanRepresentation(String trueRepresentation, String falseRepresentation) {
            this.trueRepresentation = trueRepresentation;
            this.falseRepresentation = falseRepresentation;
        }

        @Override
        public void setBoolean(PreparedStatement stmnt, int idx, boolean val) throws SQLException {
            stmnt.setString(idx, val ? this.trueRepresentation : this.falseRepresentation);
        }

        @Override
        public boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
            return this.trueRepresentation.equals(rs.getString(columnIndex));
        }

        @Override
        public String getRepresentation(boolean bool) {
            return bool ? this.trueRepresentation : this.falseRepresentation;
        }

        public String toString() {
            return "StringBooleanRepresentation with the following values for true and false: " + this.trueRepresentation + " / " + this.falseRepresentation;
        }
    }
}

