/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.io.PrintStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.Caches;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.datacache.TypesChangedListener;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.collections.AbstractReferenceMap;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.Id;

public abstract class AbstractQueryCache
extends AbstractConcurrentEventManager
implements QueryCache,
Configurable {
    private static final long serialVersionUID = 1L;
    private static final Localizer s_loc = Localizer.forPackage(AbstractQueryCache.class);
    private static final String TIMESTAMP = "timestamp";
    protected OpenJPAConfiguration conf;
    protected Log log;
    protected ConcurrentHashMap<String, Long> entityTimestampMap = null;
    private boolean _closed = false;
    private String _name = null;
    public EvictPolicy evictPolicy = EvictPolicy.DEFAULT;
    private QueryStatistics<QueryKey> _stats;
    private boolean _statsEnabled = false;

    public void setEnableStatistics(boolean enable) {
        this._statsEnabled = enable;
    }

    public boolean getEnableStatistics() {
        return this._statsEnabled;
    }

    @Override
    public QueryStatistics<QueryKey> getStatistics() {
        return this._stats;
    }

    @Override
    public void initialize(DataCacheManager manager) {
        if (this.evictPolicy == EvictPolicy.TIMESTAMP) {
            this.entityTimestampMap = new ConcurrentHashMap();
            Set<String> perTypes = this.conf.getMetaDataRepositoryInstance().getPersistentTypeNames(false, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
            if (perTypes == null) {
                return;
            }
            for (Object e : perTypes) {
                this.entityTimestampMap.put((String)e, 0L);
            }
        }
    }

    @Override
    public void onTypesChanged(TypesChangedEvent ev) {
        if (this.evictPolicy == EvictPolicy.DEFAULT) {
            this.writeLock();
            Collection keys = null;
            try {
                if (this.hasListeners()) {
                    this.fireEvent(ev);
                }
                keys = this.keySet();
            }
            finally {
                this.writeUnlock();
            }
            ArrayList<QueryKey> removes = null;
            for (Object o : keys) {
                QueryKey qk = (QueryKey)o;
                if (!qk.changeInvalidatesQuery(ev.getTypes())) continue;
                if (removes == null) {
                    removes = new ArrayList<QueryKey>();
                }
                removes.add(qk);
            }
            if (removes != null) {
                this.removeAllInternal(removes);
            }
        } else {
            Collection changedTypes = ev.getTypes();
            HashMap<String, Long> changedClasses = new HashMap<String, Long>();
            Long tstamp = System.currentTimeMillis();
            for (Object o : changedTypes) {
                String name = ((Class)o).getName();
                if (changedClasses.containsKey(name)) continue;
                changedClasses.put(name, tstamp);
            }
            this.updateEntityTimestamp(changedClasses);
        }
    }

    @Override
    public QueryResult get(QueryKey key) {
        QueryResult o;
        if (this._statsEnabled) {
            this._stats.recordExecution(key);
        }
        if ((o = this.getInternal(key)) != null && o.isTimedOut()) {
            o = null;
            this.removeInternal(key);
            if (this.log.isTraceEnabled()) {
                this.log.trace(s_loc.get("cache-timeout", key));
            }
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace(s_loc.get("cache-miss", key));
            } else {
                this.log.trace(s_loc.get("cache-hit", key));
            }
        }
        if (this._statsEnabled && o != null) {
            ((Default)this._stats).recordHit(key);
        }
        return o;
    }

    @Override
    public QueryResult put(QueryKey qk, QueryResult oids) {
        QueryResult o = this.putInternal(qk, oids);
        if (this.log.isTraceEnabled()) {
            this.log.trace(s_loc.get("cache-put", qk));
        }
        return o == null || o.isTimedOut() ? null : o;
    }

    @Override
    public QueryResult remove(QueryKey key) {
        QueryResult o = this.removeInternal(key);
        if (this._statsEnabled) {
            this._stats.recordEviction(key);
        }
        if (o != null && o.isTimedOut()) {
            o = null;
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace(s_loc.get("cache-remove-miss", key));
            } else {
                this.log.trace(s_loc.get("cache-remove-hit", key));
            }
        }
        return o;
    }

    @Override
    public boolean pin(QueryKey key) {
        boolean bool = this.pinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace(s_loc.get("cache-pin-hit", key));
            } else {
                this.log.trace(s_loc.get("cache-pin-miss", key));
            }
        }
        return bool;
    }

    @Override
    public boolean unpin(QueryKey key) {
        boolean bool = this.unpinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace(s_loc.get("cache-unpin-hit", key));
            } else {
                this.log.trace(s_loc.get("cache-unpin-miss", key));
            }
        }
        return bool;
    }

    @Override
    public void clear() {
        this.clearInternal();
        if (this.log.isTraceEnabled()) {
            this.log.trace(s_loc.get("cache-clear", "<query-cache>"));
        }
        if (this._statsEnabled) {
            this._stats.clear();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    protected void close(boolean clear) {
        if (!this._closed) {
            if (clear) {
                this.clearInternal();
            }
            this._closed = true;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void addTypesChangedListener(TypesChangedListener listen) {
        this.addListener(listen);
    }

    @Override
    public boolean removeTypesChangedListener(TypesChangedListener listen) {
        return this.removeListener(listen);
    }

    public void afterCommit(RemoteCommitEvent event) {
        if (this._closed) {
            return;
        }
        Set<Class<?>> classes = Caches.addTypesByName(this.conf, event.getPersistedTypeNames(), null);
        if (event.getPayloadType() == 2) {
            classes = Caches.addTypesByName(this.conf, event.getUpdatedTypeNames(), classes);
            classes = Caches.addTypesByName(this.conf, event.getDeletedTypeNames(), classes);
        } else {
            classes = this.addTypes(event.getUpdatedObjectIds(), classes);
            classes = this.addTypes(event.getDeletedObjectIds(), classes);
        }
        if (classes != null) {
            this.onTypesChanged(new TypesChangedEvent(this, classes));
        }
    }

    private Set addTypes(Collection oids, Set classes) {
        if (oids.isEmpty()) {
            return classes;
        }
        if (classes == null) {
            classes = new HashSet();
        }
        MetaDataRepository repos = this.conf.getMetaDataRepositoryInstance();
        for (Object o : oids) {
            Object oid = o;
            if (oid instanceof Id) {
                classes.add(((Id)oid).getType());
                continue;
            }
            ClassMetaData meta = repos.getMetaData(oid, null, false);
            if (meta == null) continue;
            classes.add(meta.getDescribedType());
        }
        return classes;
    }

    protected abstract Collection keySet();

    protected abstract QueryResult getInternal(QueryKey var1);

    protected abstract QueryResult putInternal(QueryKey var1, QueryResult var2);

    protected abstract QueryResult removeInternal(QueryKey var1);

    protected void removeAllInternal(Collection qks) {
        for (Object qk : qks) {
            this.removeInternal((QueryKey)qk);
        }
    }

    protected abstract void clearInternal();

    protected abstract boolean pinInternal(QueryKey var1);

    protected abstract boolean unpinInternal(QueryKey var1);

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = (OpenJPAConfiguration)conf;
        this.log = conf.getLog("openjpa.DataCache");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this._stats = this._statsEnabled ? new Default() : new QueryStatistics.None();
    }

    @Override
    protected void fireEvent(Object event, Object listener) {
        block2: {
            TypesChangedListener listen = (TypesChangedListener)listener;
            TypesChangedEvent ev = (TypesChangedEvent)event;
            try {
                listen.onTypesChanged(ev);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block2;
                this.log.warn(s_loc.get("exp-listener-ex"), e);
            }
        }
    }

    @Override
    protected Collection newListenerCollection() {
        return new ConcurrentReferenceHashSet(AbstractReferenceMap.ReferenceStrength.WEAK);
    }

    public void setEvictPolicy(String evictPolicy) {
        if (evictPolicy.equalsIgnoreCase(TIMESTAMP)) {
            this.evictPolicy = EvictPolicy.TIMESTAMP;
        }
    }

    public EvictPolicy getEvictPolicy() {
        return this.evictPolicy;
    }

    protected void updateEntityTimestamp(Map<String, Long> timestampMap) {
        if (this.entityTimestampMap != null) {
            this.entityTimestampMap.putAll(timestampMap);
        }
    }

    public List<Long> getAllEntityTimestamp(List<String> keyList) {
        ArrayList<Long> tmval = null;
        if (this.entityTimestampMap != null) {
            for (String s : keyList) {
                if (!this.entityTimestampMap.containsKey(s)) continue;
                if (tmval == null) {
                    tmval = new ArrayList<Long>();
                }
                tmval.add(this.entityTimestampMap.get(s));
            }
        }
        return tmval;
    }

    public void setName(String n) {
        this._name = n;
    }

    public String getName() {
        return this._name;
    }

    public int count() {
        return this.keySet().size();
    }

    public static class Default<T>
    implements QueryStatistics<T> {
        private static final long serialVersionUID = -7889619105916307055L;
        private static final int FIXED_SIZE = 1000;
        private static final float LOAD_FACTOR = 0.75f;
        private static final int CONCURRENCY = 16;
        private static final int ARRAY_SIZE = 3;
        private static final int READ = 0;
        private static final int HIT = 1;
        private static final int EVICT = 2;
        private long[] astat = new long[3];
        private long[] stat = new long[3];
        private Map<T, long[]> stats;
        private Map<T, long[]> astats;
        private Date start;
        private Date since = this.start = new Date();

        public Default() {
            this.initializeMaps();
        }

        private void initializeMaps() {
            ConcurrentReferenceHashMap statsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD, 16, 0.75f);
            statsMap.setMaxSize(1000);
            this.stats = statsMap;
            ConcurrentReferenceHashMap aStatsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD, 16, 0.75f);
            aStatsMap.setMaxSize(1000);
            this.astats = aStatsMap;
        }

        @Override
        public Set<T> keys() {
            return this.stats.keySet();
        }

        @Override
        public long getExecutionCount() {
            return this.stat[0];
        }

        @Override
        public long getTotalExecutionCount() {
            return this.astat[0];
        }

        @Override
        public long getExecutionCount(T query) {
            return this.getCount(this.stats, query, 0);
        }

        @Override
        public long getTotalExecutionCount(T query) {
            return this.getCount(this.astats, query, 0);
        }

        @Override
        public long getHitCount() {
            return this.stat[1];
        }

        @Override
        public long getTotalHitCount() {
            return this.astat[1];
        }

        @Override
        public long getHitCount(T query) {
            return this.getCount(this.stats, query, 1);
        }

        @Override
        public long getTotalHitCount(T query) {
            return this.getCount(this.astats, query, 1);
        }

        @Override
        public long getEvictionCount() {
            return this.stat[2];
        }

        @Override
        public long getTotalEvictionCount() {
            return this.astat[2];
        }

        private long getCount(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            return row == null ? 0L : row[i];
        }

        @Override
        public Date since() {
            return this.since;
        }

        @Override
        public Date start() {
            return this.start;
        }

        @Override
        public synchronized void reset() {
            this.stat = new long[3];
            this.stats.clear();
            this.since = new Date();
        }

        @Override
        public synchronized void clear() {
            this.astat = new long[3];
            this.stat = new long[3];
            this.initializeMaps();
            this.since = this.start = new Date();
        }

        private void addSample(T query, int index) {
            int n = index;
            this.stat[n] = this.stat[n] + 1L;
            int n2 = index;
            this.astat[n2] = this.astat[n2] + 1L;
            this.addSample(this.stats, query, index);
            this.addSample(this.astats, query, index);
        }

        private void addSample(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            if (row == null) {
                row = new long[3];
            }
            int n = i;
            row[n] = row[n] + 1L;
            target.put(query, row);
        }

        @Override
        public void recordExecution(T query) {
            if (query == null) {
                return;
            }
            this.addSample(query, 0);
        }

        public void recordHit(T query) {
            this.addSample(query, 1);
        }

        @Override
        public void recordEviction(T query) {
            if (query == null) {
                return;
            }
            this.addSample(query, 2);
        }

        @Override
        public void dump(PrintStream out) {
            String header = "Query Statistics starting from " + this.start;
            out.print(header);
            if (this.since == this.start) {
                out.println();
                out.println("Total Query Execution: " + this.toString(this.astat));
                out.println("\tTotal \t\tQuery");
            } else {
                out.println(" last reset on " + this.since);
                out.println("Total Query Execution since start " + this.toString(this.astat) + " since reset " + this.toString(this.stat));
                out.println("\tSince Start \tSince Reset \t\tQuery");
            }
            int i = 0;
            for (T key : this.stats.keySet()) {
                ++i;
                long[] arow = this.astats.get(key);
                if (this.since == this.start) {
                    out.println(i + ". \t" + this.toString(arow) + " \t" + key);
                    continue;
                }
                long[] row = this.stats.get(key);
                out.println(i + ". \t" + this.toString(arow) + " \t" + this.toString(row) + " \t\t" + key);
            }
        }

        long pct(long per, long cent) {
            if (cent <= 0L) {
                return 0L;
            }
            return 100L * per / cent;
        }

        String toString(long[] row) {
            return row[0] + ":" + row[1] + "(" + this.pct(row[1], row[0]) + "%)";
        }
    }

    public static enum EvictPolicy {
        DEFAULT,
        TIMESTAMP;

    }
}

