/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Objects;
import org.apache.bval.util.Exceptions;

public class ConstraintViolationImpl<T>
implements ConstraintViolation<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String messageTemplate;
    private final String message;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final Object leafBean;
    private final Object value;
    private final Path propertyPath;
    private final ElementType elementType;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private final Object returnValue;
    private final Object[] parameters;
    private final int hashCode;

    public ConstraintViolationImpl(String messageTemplate, String message, T rootBean, Object leafBean, Path propertyPath, Object value, ConstraintDescriptor<?> constraintDescriptor, Class<T> rootBeanClass, ElementType elementType, Object returnValue, Object[] parameters) {
        this.messageTemplate = messageTemplate;
        this.message = message;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.propertyPath = propertyPath;
        this.leafBean = leafBean;
        this.value = value;
        this.constraintDescriptor = constraintDescriptor;
        this.elementType = elementType;
        this.returnValue = returnValue;
        this.parameters = parameters;
        this.hashCode = Arrays.deepHashCode(new Object[]{messageTemplate, message, rootBean, rootBeanClass, leafBean, value, propertyPath, elementType, constraintDescriptor, returnValue, parameters});
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    @Override
    public T getRootBean() {
        return this.rootBean;
    }

    @Override
    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    @Override
    public Object getLeafBean() {
        return this.leafBean;
    }

    @Override
    public Object[] getExecutableParameters() {
        return this.parameters;
    }

    @Override
    public Object getExecutableReturnValue() {
        return this.returnValue;
    }

    @Override
    public Object getInvalidValue() {
        return this.value;
    }

    @Override
    public Path getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    @Override
    public <U> U unwrap(Class<U> type) {
        if (!type.isInstance(this)) {
            Exceptions.raise(ValidationException::new, "Type %s is not supported", type);
        }
        return type.cast(this);
    }

    public String toString() {
        return String.format("%s{rootBean=%s, propertyPath='%s', message='%s', leafBean=%s, value=%s}", ConstraintViolationImpl.class.getSimpleName(), this.rootBean, this.propertyPath, this.message, this.leafBean, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ConstraintViolationImpl that = (ConstraintViolationImpl)o;
        return Objects.equals(this.constraintDescriptor, that.constraintDescriptor) && this.elementType == that.elementType && Objects.equals(this.leafBean, that.leafBean) && Objects.equals(this.message, that.message) && Objects.equals(this.messageTemplate, that.messageTemplate) && Arrays.equals(this.parameters, that.parameters) && Objects.equals(this.propertyPath, that.propertyPath) && Objects.equals(this.returnValue, that.returnValue) && Objects.equals(this.rootBean, that.rootBean) && Objects.equals(this.rootBeanClass, that.rootBeanClass) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

