/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolableCallableStatement;
import org.apache.commons.dbcp2.PoolablePreparedStatement;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pStmtPool;
    private boolean clearStatementPoolOnReturn;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    @Override
    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        pooledObject.getObject().activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block11: {
            try {
                if (null == this.pStmtPool) break block11;
                KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldPool = this.pStmtPool;
                this.pStmtPool = null;
                try {
                    oldPool.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Cannot close connection", e);
                }
            }
            finally {
                try {
                    this.getDelegateInternal().close();
                }
                finally {
                    this.setClosedInternal(true);
                }
            }
        }
    }

    public void connectionReturnedToPool() throws SQLException {
        if (this.pStmtPool != null && this.clearStatementPoolOnReturn) {
            try {
                this.pStmtPool.clear();
            }
            catch (Exception e) {
                throw new SQLException("Error clearing statement pool", e);
            }
        }
    }

    protected PStmtKey createKey(String sql2) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String sql2, int autoGeneratedKeys) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql2, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql2, int resultSetType, int resultSetConcurrency, int resultSetHoldability, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability, statementType);
    }

    protected PStmtKey createKey(String sql2, int resultSetType, int resultSetConcurrency, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, statementType);
    }

    protected PStmtKey createKey(String sql2, int[] columnIndexes) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), columnIndexes);
    }

    protected PStmtKey createKey(String sql2, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), statementType, null);
    }

    protected PStmtKey createKey(String sql2, String[] columnNames) {
        return new PStmtKey(this.normalizeSQL(sql2), this.getCatalogOrNull(), this.getSchemaOrNull(), columnNames);
    }

    @Override
    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        Statement innermostDelegate;
        DelegatingPreparedStatement object;
        if (pooledObject != null && (object = pooledObject.getObject()) != null && (innermostDelegate = object.getInnermostDelegate()) != null) {
            innermostDelegate.close();
        }
    }

    private String getCatalogOrNull() {
        try {
            return this.getCatalog();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private String getSchemaOrNull() {
        try {
            return this.getSchema();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    public KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> getStatementPool() {
        return this.pStmtPool;
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws SQLException {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement((Connection)this.getDelegate());
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this.pStmtPool, this);
            return new DefaultPooledObject<DelegatingPreparedStatement>(pps);
        }
        CallableStatement statement = (CallableStatement)key.createStatement((Connection)this.getDelegate());
        PoolableCallableStatement pcs = new PoolableCallableStatement(statement, key, this.pStmtPool, this);
        return new DefaultPooledObject<DelegatingPreparedStatement>(pcs);
    }

    protected String normalizeSQL(String sql2) {
        return sql2.trim();
    }

    @Override
    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        DelegatingPreparedStatement dps = pooledObject.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    private CallableStatement prepareCall(PStmtKey key) throws SQLException {
        return (CallableStatement)this.prepareStatement(key);
    }

    @Override
    public CallableStatement prepareCall(String sql2) throws SQLException {
        return this.prepareCall(this.createKey(sql2, StatementType.CALLABLE_STATEMENT));
    }

    @Override
    public CallableStatement prepareCall(String sql2, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(this.createKey(sql2, resultSetType, resultSetConcurrency, StatementType.CALLABLE_STATEMENT));
    }

    @Override
    public CallableStatement prepareCall(String sql2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(this.createKey(sql2, resultSetType, resultSetConcurrency, resultSetHoldability, StatementType.CALLABLE_STATEMENT));
    }

    private PreparedStatement prepareStatement(PStmtKey key) throws SQLException {
        if (null == this.pStmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this.pStmtPool.borrowObject(key);
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql2) throws SQLException {
        return this.prepareStatement(this.createKey(sql2));
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(this.createKey(sql2, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(this.createKey(sql2, resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(this.createKey(sql2, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(this.createKey(sql2, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql2, String[] columnNames) throws SQLException {
        return this.prepareStatement(this.createKey(sql2, columnNames));
    }

    public void setClearStatementPoolOnReturn(boolean clearStatementPoolOnReturn) {
        this.clearStatementPoolOnReturn = clearStatementPoolOnReturn;
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this.pStmtPool = pool;
    }

    @Override
    public synchronized String toString() {
        GenericKeyedObjectPool gkop;
        if (this.pStmtPool instanceof GenericKeyedObjectPool && (gkop = (GenericKeyedObjectPool)this.pStmtPool).getFactory() == this) {
            return "PoolingConnection: " + this.pStmtPool.getClass() + "@" + System.identityHashCode(this.pStmtPool);
        }
        return "PoolingConnection: " + Objects.toString(this.pStmtPool);
    }

    @Override
    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

