/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SystemAggregator;
import org.apache.derby.shared.common.error.StandardException;

public final class CountAggregator
extends SystemAggregator {
    private long value;
    private boolean isCountStar;

    @Override
    public void setup(ClassFactory classFactory, String string, DataTypeDescriptor dataTypeDescriptor) {
        this.isCountStar = string.equals("COUNT(*)");
    }

    @Override
    public void merge(ExecAggregator execAggregator) throws StandardException {
        this.value += ((CountAggregator)execAggregator).value;
    }

    @Override
    public DataValueDescriptor getResult() {
        return new SQLLongint(this.value);
    }

    @Override
    public void accumulate(DataValueDescriptor dataValueDescriptor, Object object) throws StandardException {
        if (this.isCountStar) {
            ++this.value;
        } else {
            super.accumulate(dataValueDescriptor, object);
        }
    }

    @Override
    protected final void accumulate(DataValueDescriptor dataValueDescriptor) {
        ++this.value;
    }

    @Override
    public ExecAggregator newAggregator() {
        CountAggregator countAggregator = new CountAggregator();
        countAggregator.isCountStar = this.isCountStar;
        return countAggregator;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    @Override
    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isCountStar);
        objectOutput.writeLong(this.value);
    }

    @Override
    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isCountStar = objectInput.readBoolean();
        this.value = objectInput.readLong();
    }

    @Override
    public int getTypeFormatId() {
        return 151;
    }
}

