/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationAlert;
import java.time.Duration;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.FencedFeedbackPanel;
import org.apache.wicket.feedback.IFeedbackMessageFilter;

public class NotificationPanel
extends FencedFeedbackPanel {
    private Duration duration;
    private static final IFeedbackMessageFilter SKIP_RENDERED_MESSAGES_FILTER = new IFeedbackMessageFilter(){

        public boolean accept(FeedbackMessage message) {
            return !message.isRendered();
        }
    };

    public NotificationPanel(String id) {
        this(id, (Component)null);
    }

    public NotificationPanel(String id, Component fence) {
        this(id, fence, null);
    }

    public NotificationPanel(String id, IFeedbackMessageFilter filter) {
        this(id, null, filter);
    }

    public NotificationPanel(String id, Component fence, IFeedbackMessageFilter filter) {
        super(id, fence, filter);
        BootstrapJavascriptBehavior.addTo((Component)this);
    }

    public NotificationPanel showRenderedMessages(boolean showRenderedMessages) {
        if (showRenderedMessages) {
            this.setFilter(IFeedbackMessageFilter.ALL);
        } else {
            this.setFilter(SKIP_RENDERED_MESSAGES_FILTER);
        }
        return this;
    }

    public NotificationPanel hideAfter(Duration duration) {
        this.duration = duration;
        return this;
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        FeedbackMessagesModel model = super.newFeedbackMessagesModel();
        model.setFilter(SKIP_RENDERED_MESSAGES_FILTER);
        return model;
    }

    protected String getCSSClass(FeedbackMessage message) {
        return null;
    }

    protected Component newMessageDisplayComponent(String markupId, FeedbackMessage message) {
        NotificationAlert alert = new NotificationAlert(markupId, message, this.duration);
        alert.setCloseButtonVisible(this.isCloseButtonVisible());
        return alert;
    }

    protected boolean isCloseButtonVisible() {
        return true;
    }
}

