/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.asteriskjava.util.Log;

public class JavaLoggingLog
implements Log {
    private final Logger log;

    public JavaLoggingLog(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
    }

    @Override
    public void debug(Object obj) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.FINE, ste.getClassName(), ste.getMethodName(), obj.toString());
        } else {
            this.log.fine(obj.toString());
        }
    }

    @Override
    public void info(Object obj) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.INFO, ste.getClassName(), ste.getMethodName(), obj.toString());
        } else {
            this.log.info(obj.toString());
        }
    }

    @Override
    public void warn(Object obj) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.WARNING, ste.getClassName(), ste.getMethodName(), obj.toString());
        } else {
            this.log.warning(obj.toString());
        }
    }

    @Override
    public void warn(Object obj, Throwable ex) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.WARNING, ste.getClassName(), ste.getMethodName(), obj.toString(), ex);
        } else {
            this.log.log(Level.WARNING, obj.toString(), ex);
        }
    }

    @Override
    public void error(Object obj) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName(), obj.toString());
        } else {
            this.log.severe(obj.toString());
        }
    }

    @Override
    public void error(Object obj, Throwable ex) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.SEVERE, ste.getClassName(), ste.getMethodName(), obj.toString(), ex);
        } else {
            this.log.log(Level.SEVERE, obj.toString(), ex);
        }
    }

    private StackTraceElement getInvokerSTE() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack.length > 2) {
            return stack[2];
        }
        return null;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public void debug(Object e, Throwable e2) {
        StackTraceElement ste = this.getInvokerSTE();
        if (ste != null) {
            this.log.logp(Level.FINE, ste.getClassName(), ste.getMethodName(), e.toString(), e2);
        } else {
            this.log.log(Level.FINE, e.toString(), e2);
        }
    }
}

