/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import com.github.openjson.JSONObject;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import org.apache.openmeetings.db.entity.room.Invitation;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InvitationDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String email;
    private String firstname;
    private String lastname;
    private String message;
    private String subject;
    private Long roomId;
    private boolean passwordProtected;
    private String password;
    private Invitation.Valid valid;
    private String validFrom;
    private String validTo;
    private long languageId;

    public String getEmail() {
        return this.email;
    }

    public InvitationDTO setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public InvitationDTO setFirstname(String firstname) {
        this.firstname = firstname;
        return this;
    }

    public String getLastname() {
        return this.lastname;
    }

    public InvitationDTO setLastname(String lastname) {
        this.lastname = lastname;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public InvitationDTO setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public InvitationDTO setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public InvitationDTO setRoomId(Long roomId) {
        this.roomId = roomId;
        return this;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public InvitationDTO setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public InvitationDTO setPassword(String password) {
        this.password = password;
        return this;
    }

    public Invitation.Valid getValid() {
        return this.valid;
    }

    public InvitationDTO setValid(Invitation.Valid valid) {
        this.valid = valid;
        return this;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public InvitationDTO setValidFrom(String validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public InvitationDTO setValidTo(String validTo) {
        this.validTo = validTo;
        return this;
    }

    public long getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(long languageId) {
        this.languageId = languageId;
    }

    public static InvitationDTO fromString(String s) {
        return InvitationDTO.get(new JSONObject(s));
    }

    public static InvitationDTO get(JSONObject o) {
        if (o == null) {
            return null;
        }
        InvitationDTO i = new InvitationDTO();
        i.firstname = o.optString("firstname");
        i.lastname = o.optString("lastname");
        i.email = o.optString("email");
        i.password = o.optString("password");
        i.passwordProtected = o.optBoolean("passwordProtected", false);
        i.subject = o.optString("subject");
        i.roomId = o.getLong("roomId");
        i.message = o.optString("message");
        i.valid = Invitation.Valid.valueOf(o.optString("valid", Invitation.Valid.PERIOD.name()));
        i.validFrom = o.optString("validFrom");
        i.validTo = o.optString("validTo");
        return i;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

