/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueContainer;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncRequestValueGrammar
extends AbstractGrammar<SyncRequestValueContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SyncRequestValueGrammar.class);
    private static Grammar<SyncRequestValueContainer> instance = new SyncRequestValueGrammar();

    private SyncRequestValueGrammar() {
        this.setName(SyncRequestValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncRequestValueStatesEnum.LAST_SYNC_REQUEST_VALUE_STATE.ordinal()][256];
        this.transitions[SyncRequestValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(SyncRequestValueStatesEnum.START_STATE, SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.SYNC_REQUEST_VALUE_SEQUENCE_STATE, SyncRequestValueStatesEnum.MODE_STATE, UniversalTag.ENUMERATED.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl mode"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int mode = IntegerDecoder.parse(value, SynchronizationModeEnum.UNUSED.getValue(), SynchronizationModeEnum.REFRESH_AND_PERSIST.getValue());
                    SynchronizationModeEnum modeEnum = SynchronizationModeEnum.getSyncMode(mode);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08100_MODE, new Object[]{modeEnum}));
                    }
                    container.getSyncRequestValue().setMode(modeEnum);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_08100_SYNC_REQUEST_VALUE_MODE_DECODING_FAILED, new Object[0]);
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.MODE_STATE, SyncRequestValueStatesEnum.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl cookie"){

            @Override
            public void action(SyncRequestValueContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08000_COOKIE, Strings.dumpBytes(cookie)));
                }
                container.getSyncRequestValue().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncRequestValueStatesEnum.MODE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.MODE_STATE, SyncRequestValueStatesEnum.RELOAD_HINT_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08104_RELOAD_HINT, reloadHint));
                    }
                    container.getSyncRequestValue().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    String msg = I18n.err(I18n.ERR_08101_RELOAD_HINT_DECODING_FAILED, new Object[0]);
                    LOG.error(msg, (Throwable)bde);
                    throw new DecoderException(msg, bde);
                }
            }
        });
        this.transitions[SyncRequestValueStatesEnum.COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncRequestValueContainer>(SyncRequestValueStatesEnum.COOKIE_STATE, SyncRequestValueStatesEnum.RELOAD_HINT_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncRequestValueContainer>("Set SyncRequestValueControl reloadHint flag"){

            @Override
            public void action(SyncRequestValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08104_RELOAD_HINT, reloadHint));
                    }
                    container.getSyncRequestValue().setReloadHint(reloadHint);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    String msg = I18n.err(I18n.ERR_08101_RELOAD_HINT_DECODING_FAILED, new Object[0]);
                    LOG.error(msg, (Throwable)bde);
                    throw new DecoderException(msg, bde);
                }
            }
        });
    }

    public static Grammar<SyncRequestValueContainer> getInstance() {
        return instance;
    }
}

