/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport;

import com.hazelcast.internal.locksupport.LockResourceImpl;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.operations.IsLockedOperation;
import com.hazelcast.internal.locksupport.operations.LockBackupOperation;
import com.hazelcast.internal.locksupport.operations.LockOperation;
import com.hazelcast.internal.locksupport.operations.LockReplicationOperation;
import com.hazelcast.internal.locksupport.operations.UnlockBackupOperation;
import com.hazelcast.internal.locksupport.operations.UnlockIfLeaseExpiredOperation;
import com.hazelcast.internal.locksupport.operations.UnlockOperation;
import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;

public final class LockDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.lock", -8);
    public static final int LOCK_RESOURCE = 0;
    public static final int LOCK_STORE = 1;
    public static final int IS_LOCKED = 9;
    public static final int LOCK_BACKUP = 10;
    public static final int LOCK = 11;
    public static final int LOCK_REPLICATION = 12;
    public static final int UNLOCK_BACKUP = 15;
    public static final int UNLOCK = 16;
    public static final int UNLOCK_IF_LEASE_EXPIRED = 17;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return typeId -> switch (typeId) {
            case 9 -> new IsLockedOperation();
            case 11 -> new LockOperation();
            case 10 -> new LockBackupOperation();
            case 12 -> new LockReplicationOperation();
            case 15 -> new UnlockBackupOperation();
            case 16 -> new UnlockOperation();
            case 1 -> new LockStoreImpl();
            case 0 -> new LockResourceImpl();
            case 17 -> new UnlockIfLeaseExpiredOperation();
            default -> null;
        };
    }
}

