/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import java.util.Arrays;

public abstract class AbstractInternalPartition
implements InternalPartition {
    protected final int partitionId;

    protected AbstractInternalPartition(int partitionId) {
        this.partitionId = partitionId;
    }

    protected abstract PartitionReplica[] replicas();

    @Override
    public final int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public Address getOwnerOrNull() {
        PartitionReplica replica = this.replicas()[0];
        return AbstractInternalPartition.getAddress(replica);
    }

    @Override
    public PartitionReplica getOwnerReplicaOrNull() {
        return this.replicas()[0];
    }

    @Override
    public Address getReplicaAddress(int replicaIndex) {
        return AbstractInternalPartition.getAddress(this.getReplica(replicaIndex));
    }

    protected static Address getAddress(PartitionReplica replica) {
        return replica != null ? replica.address() : null;
    }

    @Override
    public boolean isOwnerOrBackup(Address address) {
        if (address == null) {
            return false;
        }
        for (PartitionReplica replica : this.replicas()) {
            if (!address.equals(AbstractInternalPartition.getAddress(replica))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOwnerOrBackup(PartitionReplica replica) {
        return AbstractInternalPartition.getReplicaIndex(this.replicas(), replica) >= 0;
    }

    @Override
    public PartitionReplica getReplica(int replicaIndex) {
        if (replicaIndex >= 7) {
            throw new ArrayIndexOutOfBoundsException(replicaIndex);
        }
        PartitionReplica[] replicas = this.replicas();
        if (replicaIndex >= replicas.length) {
            return null;
        }
        return replicas[replicaIndex];
    }

    @Override
    public int getReplicaIndex(PartitionReplica replica) {
        return AbstractInternalPartition.getReplicaIndex(this.replicas(), replica);
    }

    @Override
    public PartitionReplica[] getReplicasCopy() {
        return Arrays.copyOf(this.replicas(), 7);
    }

    public static int getReplicaIndex(PartitionReplica[] replicas, PartitionReplica replica) {
        if (replica == null) {
            return -1;
        }
        for (int i = 0; i < replicas.length; ++i) {
            if (!replica.equals(replicas[i])) continue;
            return i;
        }
        return -1;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInternalPartition)) {
            return false;
        }
        AbstractInternalPartition that = (AbstractInternalPartition)o;
        if (this.partitionId != that.getPartitionId()) {
            return false;
        }
        if (this.version() != that.version()) {
            return false;
        }
        return Arrays.equals(this.replicas(), that.replicas());
    }

    public final int hashCode() {
        int result = Arrays.hashCode(this.replicas());
        result = 31 * result + this.partitionId;
        result = 31 * result + this.version();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition {ID: ").append(this.partitionId).append(", Version: ").append(this.version()).append("} [\n");
        PartitionReplica[] replicas = this.replicas();
        for (int i = 0; i < replicas.length; ++i) {
            PartitionReplica replica = replicas[i];
            if (replica == null) continue;
            sb.append('\t');
            sb.append(i).append(":").append(replica);
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }
}

