/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.ThreadAffinityHelper;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadAffinity {
    public static final ThreadAffinity DISABLED = new ThreadAffinity(null);
    final List<BitSet> allowedCpusList;
    final AtomicInteger threadIndex = new AtomicInteger();

    public ThreadAffinity(String affinity) {
        this.allowedCpusList = ThreadAffinity.parse(affinity);
        if (this.allowedCpusList.isEmpty()) {
            return;
        }
        if (!ThreadAffinityHelper.isAffinityAvailable()) {
            throw new RuntimeException("Can't use affinity '" + affinity + "'. Thread affinity support is not available.");
        }
    }

    public static ThreadAffinity newSystemThreadAffinity(String property) {
        String value = System.getProperty(property);
        try {
            return new ThreadAffinity(value);
        }
        catch (InvalidAffinitySyntaxException e) {
            throw new InvalidAffinitySyntaxException("Invalid affinity syntax for System property '" + property + "'. Value '" + value + "'.  Errormessage '" + e.getMessage() + "'");
        }
    }

    static List<BitSet> parse(String affinity) {
        ArrayList<BitSet> cpus = new ArrayList<BitSet>();
        if (affinity == null) {
            return cpus;
        }
        if ((affinity = affinity.trim()).isEmpty()) {
            return cpus;
        }
        List<CpuGroup> groups = new AffinityParser(affinity).parse();
        for (CpuGroup group : groups) {
            BitSet allowedCpus = new BitSet();
            for (Integer cpu : group.cpus) {
                allowedCpus.set(cpu);
            }
            for (int k = 0; k < group.threadCount; ++k) {
                cpus.add(allowedCpus);
            }
        }
        return cpus;
    }

    public int getThreadCount() {
        return this.allowedCpusList.size();
    }

    public BitSet nextAllowedCpus() {
        if (this.allowedCpusList.isEmpty()) {
            return null;
        }
        int index = this.threadIndex.getAndIncrement() % this.allowedCpusList.size();
        return this.allowedCpusList.get(index);
    }

    public boolean isEnabled() {
        return !this.allowedCpusList.isEmpty();
    }

    static class InvalidAffinitySyntaxException
    extends RuntimeException {
        InvalidAffinitySyntaxException(String message) {
            super(message);
        }
    }

    static class AffinityParser {
        private final String string;
        private final List<CpuGroup> groups = new ArrayList<CpuGroup>();
        private int index;
        private int digit;
        private int integer;
        private int fromRange;
        private int toRange;

        AffinityParser(String string) {
            this.string = string;
        }

        List<CpuGroup> parse() {
            if (!this.expression() || this.index < this.string.length()) {
                throw new InvalidAffinitySyntaxException("Syntax Error at " + this.index);
            }
            BitSet usedCpus = new BitSet();
            for (CpuGroup group : this.groups) {
                for (Integer cpu : group.cpus) {
                    if (usedCpus.get(cpu)) {
                        throw new InvalidAffinitySyntaxException("Duplicate CPU found, offending CPU=" + cpu);
                    }
                    usedCpus.set(cpu);
                }
            }
            return this.groups;
        }

        boolean expression() {
            if (!this.item()) {
                return false;
            }
            while (this.character(',')) {
                if (this.item()) continue;
                return false;
            }
            return true;
        }

        boolean item() {
            if (this.range()) {
                for (int cpu = this.fromRange; cpu <= this.toRange; ++cpu) {
                    CpuGroup group = new CpuGroup();
                    group.cpus.add(cpu);
                    group.threadCount = 1;
                    this.groups.add(group);
                }
                return true;
            }
            return this.group();
        }

        boolean range() {
            if (!this.integer()) {
                return false;
            }
            this.fromRange = this.integer;
            this.toRange = this.integer;
            if (this.character('-')) {
                if (!this.integer()) {
                    return false;
                }
                this.toRange = this.integer;
                if (this.toRange < this.fromRange) {
                    this.error("ToRange can't smaller than fromRange, toRange=" + this.toRange + " fromRange=" + this.fromRange + ".");
                }
            }
            return true;
        }

        private void error(String error) {
            throw new InvalidAffinitySyntaxException(error + " at index:" + this.index);
        }

        boolean group() {
            if (!this.character('[')) {
                return false;
            }
            if (!this.range()) {
                return false;
            }
            CpuGroup group = new CpuGroup();
            this.addCpuRangeToGroup(group);
            while (this.character(',')) {
                if (!this.range()) {
                    return false;
                }
                this.addCpuRangeToGroup(group);
            }
            if (!this.character(']')) {
                return false;
            }
            if (this.character(':')) {
                if (!this.integer()) {
                    return false;
                }
                group.threadCount = this.integer;
                if (group.threadCount == 0) {
                    this.error("Thread count can't be 0.");
                } else if (group.threadCount > group.cpus.size()) {
                    this.error("Thread count can't be larger than number of cpu's in the group. Thread count = " + group.threadCount + " cpus:" + group.cpus);
                }
            } else {
                group.threadCount = group.cpus.size();
            }
            this.groups.add(group);
            return true;
        }

        private void addCpuRangeToGroup(CpuGroup group) {
            for (int k = this.fromRange; k <= this.toRange; ++k) {
                group.cpus.add(k);
            }
        }

        boolean integer() {
            if (!this.digit()) {
                return false;
            }
            this.integer = this.digit;
            while (this.digit()) {
                this.integer *= 10;
                this.integer += this.digit;
            }
            return true;
        }

        boolean digit() {
            if (this.index >= this.string.length()) {
                return false;
            }
            char c = this.string.charAt(this.index);
            if (Character.isDigit(c)) {
                ++this.index;
                this.digit = Character.getNumericValue(c);
                return true;
            }
            return false;
        }

        boolean character(char expected) {
            if (this.index >= this.string.length()) {
                return false;
            }
            char c = this.string.charAt(this.index);
            if (c == expected) {
                ++this.index;
                return true;
            }
            return false;
        }
    }

    static class CpuGroup {
        List<Integer> cpus = new LinkedList<Integer>();
        int threadCount = -1;

        CpuGroup() {
        }

        public String toString() {
            return "CpuGroup{cpus=" + this.cpus + ", count=" + this.threadCount + "}";
        }
    }
}

