/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.connector.HazelcastReaders;
import com.hazelcast.jet.impl.connector.RemoteMapSourceConfiguration;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RemoteMapSourceBuilder<K, V, T> {
    private final String mapName;
    private DataConnectionRef dataConnectionRef;
    private ClientConfig clientConfig;
    private Predicate<K, V> predicate;
    private Projection<? super Map.Entry<K, V>, ? extends T> projection;

    RemoteMapSourceBuilder(String mapName) {
        Objects.requireNonNull(mapName, "mapName can not be null");
        this.mapName = mapName;
    }

    public RemoteMapSourceBuilder<K, V, T> dataConnectionRef(@Nonnull DataConnectionRef dataConnectionRef) {
        this.dataConnectionRef = Objects.requireNonNull(dataConnectionRef, "dataConnectionRef can not be null");
        return this;
    }

    public RemoteMapSourceBuilder<K, V, T> clientConfig(@Nonnull ClientConfig clientConfig) {
        this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig can not be null");
        return this;
    }

    public RemoteMapSourceBuilder<K, V, T> predicate(@Nonnull Predicate<K, V> predicate) {
        Objects.requireNonNull(predicate, "predicate can not be null");
        Util.checkSerializable(predicate, "predicate");
        this.predicate = predicate;
        return this;
    }

    public <T_NEW> RemoteMapSourceBuilder<K, V, T_NEW> projection(@Nonnull Projection<? super Map.Entry<K, V>, ? extends T_NEW> projection) {
        Objects.requireNonNull(projection, "projection can not be null");
        Util.checkSerializable(projection, "projection");
        RemoteMapSourceBuilder newThis = this;
        newThis.projection = projection;
        return newThis;
    }

    public <N> BatchSource<N> build() {
        if (this.dataConnectionRef == null && this.clientConfig == null) {
            throw new HazelcastException("Either dataConnectionName or clientConfig must be non-null");
        }
        RemoteMapSourceConfiguration<K, V, ? extends T> configuration = new RemoteMapSourceConfiguration<K, V, T>(this.mapName, this.dataConnectionRef, this.clientConfig, this.predicate, this.projection);
        return Sources.batchFromProcessor("remoteMapSource(" + this.mapName + ")", ProcessorMetaSupplier.of(HazelcastReaders.readRemoteMapSupplier(configuration)));
    }
}

