/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ExecutorStats {
    private static final LocalExecutorStatsImpl EMPTY_LOCAL_EXECUTOR_STATS = new LocalExecutorStatsImpl();
    private final ConcurrentHashMap<String, LocalExecutorStatsImpl> statsMap = new ConcurrentHashMap();
    private final ConstructorFunction<String, LocalExecutorStatsImpl> executorStatsConstructor = key -> new LocalExecutorStatsImpl();

    public ConcurrentMap<String, LocalExecutorStatsImpl> getStatsMap() {
        return this.statsMap;
    }

    public void startExecution(String executorName, long elapsed) {
        this.getLocalExecutorStats(executorName, true).startExecution(elapsed);
    }

    public void finishExecution(String executorName, long elapsed) {
        this.getLocalExecutorStats(executorName, true).finishExecution(elapsed);
    }

    public void startPending(String executorName) {
        this.getLocalExecutorStats(executorName, true).startPending();
    }

    public void rejectExecution(String executorName) {
        this.getLocalExecutorStats(executorName, true).rejectExecution();
    }

    public void cancelExecution(String executorName) {
        this.getLocalExecutorStats(executorName, true).cancelExecution();
    }

    public LocalExecutorStatsImpl getLocalExecutorStats(String executorName, boolean createIfAbsent) {
        LocalExecutorStatsImpl localExecutorStats = this.statsMap.get(executorName);
        if (localExecutorStats != null) {
            return localExecutorStats;
        }
        if (createIfAbsent) {
            return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, executorName, this.executorStatsConstructor);
        }
        return EMPTY_LOCAL_EXECUTOR_STATS;
    }

    public void clear() {
        this.statsMap.clear();
    }

    public void removeStats(String executorName) {
        this.statsMap.remove(executorName);
    }
}

