/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutAllBackupOperation;
import com.hazelcast.map.impl.operation.steps.MergeOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.MapMergeResponse;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MergeOperation
extends MapOperation
implements PartitionAwareOperation,
BackupAwareOperation {
    private static final long MERGE_POLICY_CHECK_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private boolean disableWanReplicationEvent;
    private List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries;
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy;
    private transient int currentIndex;
    private transient boolean hasMapListener;
    private transient boolean hasWanReplication;
    private transient boolean hasBackups;
    private transient boolean hasInvalidation;
    private transient List<Data> invalidationKeys;
    private transient boolean hasMergedValues;
    private transient BitSet nonWanReplicatedKeys;
    private List backupPairs;

    public MergeOperation() {
    }

    public MergeOperation(String name, List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy, boolean disableWanReplicationEvent) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    @Override
    protected void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (this.recordStore != null) {
            this.recordStore.checkIfLoaded();
        }
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    public State createState() {
        return super.createState().setMergingEntries(this.mergingEntries).setMergePolicy(this.mergePolicy);
    }

    @Override
    public Step getStartingStep() {
        return MergeOpSteps.READ;
    }

    @Override
    public void applyState(State state) {
        this.hasMergedValues = (Boolean)state.getResult();
        this.backupPairs = state.getBackupPairs();
        this.hasBackups = this.mapContainer.getTotalBackupCount() > 0;
    }

    @Override
    protected void runInternal() {
        MergeOperation.checkMergePolicy(this.mapContainer, this.mergePolicy);
        this.hasMapListener = this.mapEventPublisher.hasEventListener(this.name);
        this.hasWanReplication = this.mapContainer.getWanContext().isWanReplicationEnabled() && !this.disableWanReplicationEvent;
        this.hasBackups = this.mapContainer.getTotalBackupCount() > 0;
        this.hasInvalidation = this.mapContainer.hasInvalidationListener();
        if (this.hasBackups) {
            this.backupPairs = new ArrayList(2 * this.mergingEntries.size());
        }
        if (this.hasInvalidation) {
            this.invalidationKeys = new ArrayList<Data>(this.mergingEntries.size());
        }
        if (this.hasWanReplication && this.hasBackups) {
            this.nonWanReplicatedKeys = new BitSet(this.mergingEntries.size());
        }
        Queue<InternalIndex> notMarkedIndexes = this.beginIndexMarking();
        int size = this.mergingEntries.size();
        while (this.currentIndex < size) {
            this.merge(this.mergingEntries.get(this.currentIndex));
            ++this.currentIndex;
        }
        this.finishIndexMarking(notMarkedIndexes);
    }

    public static void checkMergePolicy(MapContainer mapContainer, SplitBrainMergePolicy mergePolicy) {
        NodeEngine nodeEngine = mapContainer.getMapServiceContext().getNodeEngine();
        if (MergeOperation.shouldCheckNow(mapContainer.getLastInvalidMergePolicyCheckTime())) {
            try {
                MergePolicyValidator.checkMapMergePolicy(mapContainer.getMapConfig(), mergePolicy.getClass().getName(), nodeEngine.getSplitBrainMergePolicyProvider());
            }
            catch (InvalidConfigurationException e) {
                nodeEngine.getLogger(MergeOperation.class).log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void finishIndexMarking(Queue<InternalIndex> notIndexedPartitions) {
        InternalIndex indexToMark;
        while ((indexToMark = notIndexedPartitions.poll()) != null) {
            indexToMark.markPartitionAsIndexed(this.getPartitionId());
        }
    }

    public Queue<InternalIndex> beginIndexMarking() {
        int partitionId = this.getPartitionId();
        IndexRegistry indexRegistry = this.mapContainer.getOrCreateIndexRegistry(partitionId);
        InternalIndex[] indexesSnapshot = indexRegistry.getIndexes();
        LinkedList<InternalIndex> notIndexedPartitions = new LinkedList<InternalIndex>();
        for (InternalIndex internalIndex : indexesSnapshot) {
            if (internalIndex.hasPartitionIndexed(partitionId)) continue;
            internalIndex.beginPartitionUpdate();
            notIndexedPartitions.add(internalIndex);
        }
        return notIndexedPartitions;
    }

    private static boolean shouldCheckNow(AtomicLong lastLogTime) {
        long lastLogged;
        long now = Clock.currentTimeMillis();
        if (now - (lastLogged = lastLogTime.get()) >= MERGE_POLICY_CHECK_PERIOD) {
            return lastLogTime.compareAndSet(lastLogged, now);
        }
        return false;
    }

    private void merge(SplitBrainMergeTypes.MapMergeTypes<Object, Object> mergingEntry) {
        Data dataKey = this.getNodeEngine().toData(mergingEntry.getRawKey());
        Data oldValue = this.hasMapListener ? this.getValue(dataKey) : null;
        MapMergeResponse response = this.recordStore.merge(mergingEntry, this.mergePolicy, this.getCallerProvenance());
        if (response.isMergeApplied()) {
            this.hasMergedValues = true;
            Data dataValue = this.getValueOrPostProcessedValue(dataKey, this.getValue(dataKey));
            this.mapServiceContext.interceptAfterPut(this.mapContainer.getInterceptorRegistry(), dataValue);
            if (this.hasMapListener) {
                this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.MERGED, dataKey, oldValue, dataValue);
            }
            if (this.hasWanReplication) {
                if (response != MapMergeResponse.RECORDS_ARE_EQUAL) {
                    this.publishWanUpdate(dataKey, dataValue);
                } else if (this.hasBackups) {
                    this.nonWanReplicatedKeys.set(this.backupPairs.size() / 2);
                }
            }
            if (this.hasInvalidation) {
                this.invalidationKeys.add(dataKey);
            }
            if (this.hasBackups) {
                this.backupPairs.add(dataKey);
                this.backupPairs.add(dataValue);
            }
            this.evict(dataKey);
        }
    }

    public Data getValueOrPostProcessedValue(Data dataKey, Data dataValue) {
        if (!this.isPostProcessingOrHasInterceptor(this.recordStore)) {
            return dataValue;
        }
        Object record = this.recordStore.getRecord(dataKey);
        return this.mapServiceContext.toData(record.getValue());
    }

    public Data getValue(Data dataKey) {
        Object record = this.recordStore.getRecord(dataKey);
        if (record != null) {
            return this.mapServiceContext.toData(record.getValue());
        }
        return null;
    }

    @Override
    public Object getResponse() {
        return this.hasMergedValues;
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.backupPairs.isEmpty();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public void afterRunInternal() {
        this.invalidateNearCache(this.invalidationKeys);
        super.afterRunInternal();
    }

    @Override
    public Operation getBackupOperation() {
        BitSet localNonWanReplicatedKeys = this.nonWanReplicatedKeys != null && !this.nonWanReplicatedKeys.isEmpty() ? new BitSet(this.backupPairs.size()) : null;
        return new PutAllBackupOperation(this.name, this.toBackupListByRemovingEvictedRecords(localNonWanReplicatedKeys), localNonWanReplicatedKeys, this.disableWanReplicationEvent);
    }

    public void setNonWanReplicatedKeys(BitSet nonWanReplicatedKeys) {
        this.nonWanReplicatedKeys = nonWanReplicatedKeys;
    }

    @Nonnull
    private List toBackupListByRemovingEvictedRecords(@Nullable BitSet localNonWanReplicatedKeys) {
        ArrayList<Object> toBackupList = new ArrayList<Object>(this.backupPairs.size());
        boolean hasNonWanReplicatedKeys = localNonWanReplicatedKeys != null;
        for (int i = 0; i < this.backupPairs.size(); i += 2) {
            Data dataKey = (Data)this.backupPairs.get(i);
            Record record = ((DefaultRecordStore)this.recordStore).getRecordSafe(dataKey);
            if (record == null) continue;
            toBackupList.add(dataKey);
            toBackupList.add(this.backupPairs.get(i + 1));
            toBackupList.add(record);
            toBackupList.add(this.recordStore.getExpirySystem().getExpiryMetadata(dataKey));
            if (!hasNonWanReplicatedKeys || !this.nonWanReplicatedKeys.get(i / 2)) continue;
            localNonWanReplicatedKeys.set((toBackupList.size() - 4) / 4);
        }
        return toBackupList;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingEntries.size());
        for (SplitBrainMergeTypes.MapMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
        out.writeObject(this.mergePolicy);
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.mergingEntries = new ArrayList<SplitBrainMergeTypes.MapMergeTypes<Object, Object>>(size);
        for (int i = 0; i < size; ++i) {
            SplitBrainMergeTypes.MapMergeTypes mergingEntry = (SplitBrainMergeTypes.MapMergeTypes)in.readObject();
            this.mergingEntries.add(mergingEntry);
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        this.disableWanReplicationEvent = in.readBoolean();
    }

    @Override
    public int getClassId() {
        return 136;
    }
}

