/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.record.RecordReaderWriter;

public interface Record<V> {
    public static final int UNSET = -1;
    public static final Object NOT_CACHED;

    public V getValue();

    public void setValue(V var1);

    public long getCost();

    public int getVersion();

    public void setVersion(int var1);

    default public Object getCachedValueUnsafe() {
        return NOT_CACHED;
    }

    default public boolean casCachedValue(Object expectedValue, Object newValue) {
        if (!1.$assertionsDisabled && this.getCachedValueUnsafe() == NOT_CACHED) {
            throw new AssertionError();
        }
        return true;
    }

    default public long getLastAccessTime() {
        return -1L;
    }

    default public void setLastAccessTime(long lastAccessTime) {
    }

    default public long getLastUpdateTime() {
        return -1L;
    }

    default public void setLastUpdateTime(long lastUpdateTime) {
    }

    default public long getCreationTime() {
        return -1L;
    }

    default public void setCreationTime(long creationTime) {
    }

    default public int getHits() {
        return -1;
    }

    default public void setHits(int hits) {
    }

    default public long getSequence() {
        return -1L;
    }

    default public void setSequence(long sequence) {
    }

    default public long getLastStoredTime() {
        return -1L;
    }

    default public void setLastStoredTime(long lastStoredTime) {
    }

    default public void onAccess(long now) {
        this.incrementHits();
        this.setLastAccessTime(now);
    }

    default public void incrementHits() {
        int hits = this.getHits();
        if (hits < Integer.MAX_VALUE) {
            this.setHits(hits + 1);
        }
    }

    default public void onUpdate(long now) {
        this.setVersion(this.getVersion() + 1);
        this.setLastUpdateTime(now);
    }

    default public void onStore() {
        this.setLastStoredTime(Clock.currentTimeMillis());
    }

    public RecordReaderWriter getMatchingRecordReaderWriter();

    default public int getRawCreationTime() {
        return -1;
    }

    default public void setRawCreationTime(int creationTime) {
    }

    default public int getRawLastAccessTime() {
        return -1;
    }

    default public void setRawLastAccessTime(int lastAccessTime) {
    }

    default public int getRawLastUpdateTime() {
        return -1;
    }

    default public void setRawLastUpdateTime(int lastUpdateTime) {
    }

    default public int getRawLastStoredTime() {
        return -1;
    }

    default public void setRawLastStoredTime(int lastStoredTime) {
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NOT_CACHED = new Object();
    }
}

