/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.openmeetings.webservice.NetTestWebService;
import org.apache.openmeetings.webservice.util.RateLimited;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RateLimited
public class RateLimitRequestFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RateLimitRequestFilter.class);
    private static final String ATTR_LAST_ACCESS_TIME = "LAST_ACCESS_TIME";
    private static final long ALLOWED_TIME = 3000L;
    @Context
    private HttpServletRequest request;

    public void filter(ContainerRequestContext context) {
        NetTestWebService.TestType type;
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            context.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            return;
        }
        List typeList = (List)context.getUriInfo().getQueryParameters().get((Object)"type");
        if (!(typeList == null || typeList.isEmpty() || NetTestWebService.TestType.PING != (type = NetTestWebService.getTypeByString((String)typeList.get(0))) && NetTestWebService.TestType.JITTER != type)) {
            return;
        }
        if (NetTestWebService.CLIENT_COUNT.get() > NetTestWebService.getMaxClients()) {
            log.error("Download: Max client count reached");
            context.abortWith(Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).build());
            return;
        }
        Long lastAccessed = (Long)session.getAttribute(ATTR_LAST_ACCESS_TIME);
        session.setAttribute(ATTR_LAST_ACCESS_TIME, (Object)System.currentTimeMillis());
        if (lastAccessed != null && System.currentTimeMillis() - lastAccessed < 3000L) {
            context.abortWith(Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).build());
        }
    }
}

