/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.menu;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.web.app.QuickPollManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.menu.OmMenuItem;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.room.menu.RoomMenuPanel;
import org.apache.openmeetings.web.room.poll.CreatePollDialog;
import org.apache.openmeetings.web.room.poll.PollResultsDialog;
import org.apache.openmeetings.web.room.poll.VoteDialog;
import org.apache.openmeetings.web.util.CallbackFunctionHelper;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollsSubMenu
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PollsSubMenu.class);
    private static final String FUNC_QPOLL_ACTION = "quickPollAction";
    private static final String PARAM_VOTE = "vote";
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_OPEN = "open";
    private final RoomPanel room;
    private final RoomMenuPanel mp;
    private final CreatePollDialog createPoll;
    private final VoteDialog vote;
    private final PollResultsDialog pollResults;
    private OmMenuItem pollsMenu;
    private OmMenuItem pollQuickMenuItem;
    private OmMenuItem pollCreateMenuItem;
    private OmMenuItem pollVoteMenuItem;
    private OmMenuItem pollResultMenuItem;
    private final AbstractDefaultAjaxBehavior quickPollAction = new AbstractDefaultAjaxBehavior(){
        private static final long serialVersionUID = 1L;

        protected void respond(AjaxRequestTarget target) {
            try {
                if (PollsSubMenu.this.room.getRoom().isHidden(Room.RoomElement.POLL_MENU)) {
                    return;
                }
                String action = PollsSubMenu.this.mp.getRequest().getRequestParameters().getParameterValue("action").toString();
                Client c = PollsSubMenu.this.room.getClient();
                if (PollsSubMenu.ACTION_OPEN.equals(action)) {
                    PollsSubMenu.this.qpollManager.start(PollsSubMenu.this.room.getClient());
                } else if (PollsSubMenu.ACTION_CLOSE.equals(action)) {
                    PollsSubMenu.this.qpollManager.close(c);
                } else if (PollsSubMenu.PARAM_VOTE.equals(action)) {
                    boolean curVote = PollsSubMenu.this.mp.getRequest().getRequestParameters().getParameterValue(PollsSubMenu.PARAM_VOTE).toBoolean();
                    PollsSubMenu.this.qpollManager.vote(c, curVote);
                }
            }
            catch (Exception e) {
                log.error("Unexpected exception while toggle 'quickPollAction'", (Throwable)e);
            }
        }
    };
    private final boolean visible;
    @Inject
    private QuickPollManager qpollManager;
    @Inject
    private PollDao pollDao;

    public PollsSubMenu(RoomPanel room, RoomMenuPanel mp) {
        Injector.get().inject((Object)this);
        this.room = room;
        this.mp = mp;
        Component[] componentArray = new Component[1];
        this.createPoll = new CreatePollDialog("createPoll", room.getRoom().getId());
        componentArray[0] = this.createPoll;
        mp.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.vote = new VoteDialog(PARAM_VOTE);
        componentArray2[0] = this.vote;
        mp.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.pollResults = new PollResultsDialog("pollResults", this.createPoll, room.getRoom().getId());
        componentArray3[0] = this.pollResults;
        mp.add(componentArray3);
        this.visible = !room.getRoom().isHidden(Room.RoomElement.POLL_MENU);
    }

    public void init() {
        this.pollsMenu = new OmMenuItem(this.mp.getString("menu.polls"), null, false);
        this.pollQuickMenuItem = new OmMenuItem(this.mp.getString("menu.polls.quick.title"), this.mp.getString("menu.polls.quick.descr"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                PollsSubMenu.this.qpollManager.start(PollsSubMenu.this.room.getClient());
            }
        };
        this.pollCreateMenuItem = new OmMenuItem(this.mp.getString("24"), this.mp.getString("1483"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                PollsSubMenu.this.createPoll.updateModel(target);
                PollsSubMenu.this.createPoll.show((IPartialPageRequestHandler)target);
            }
        };
        this.pollVoteMenuItem = new OmMenuItem(this.mp.getString("32"), this.mp.getString("1485"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                RoomPoll rp = PollsSubMenu.this.pollDao.getByRoom(PollsSubMenu.this.room.getRoom().getId());
                if (rp != null) {
                    PollsSubMenu.this.vote.updateModel((IPartialPageRequestHandler)target, rp);
                    PollsSubMenu.this.vote.show((IPartialPageRequestHandler)target);
                }
            }
        };
        this.pollResultMenuItem = new OmMenuItem(this.mp.getString("37"), this.mp.getString("1484"), false){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                PollsSubMenu.this.pollResults.updateModel((IPartialPageRequestHandler)target, true, PollsSubMenu.this.room.getClient().hasRight(Room.Right.MODERATOR));
                PollsSubMenu.this.pollResults.show((IPartialPageRequestHandler)target);
            }
        };
        this.mp.add(new Behavior[]{this.quickPollAction});
    }

    OmMenuItem getMenu() {
        this.pollsMenu.add(this.pollQuickMenuItem).add(this.pollCreateMenuItem).add(this.pollResultMenuItem).add(this.pollVoteMenuItem);
        return this.pollsMenu;
    }

    public void update(boolean moder, boolean notExternalUser, Room r) {
        if (!this.visible) {
            return;
        }
        boolean pollExists = this.pollDao.hasPoll(r.getId());
        this.pollsMenu.setVisible(moder || r.isAllowUserQuestions());
        this.pollQuickMenuItem.setVisible(this.room.getClient().hasRight(Room.Right.PRESENTER) && !this.qpollManager.isStarted(r.getId()));
        this.pollCreateMenuItem.setVisible(moder);
        this.pollVoteMenuItem.setVisible(pollExists && notExternalUser && this.pollDao.notVoted(r.getId(), WebSession.getUserId()));
        this.pollResultMenuItem.setVisible(pollExists || !this.pollDao.getArchived(r.getId()).isEmpty());
    }

    public void updatePoll(IPartialPageRequestHandler handler, Long createdBy) {
        RoomPoll rp = this.pollDao.getByRoom(this.room.getRoom().getId());
        if (rp != null) {
            this.vote.updateModel(handler, rp);
        } else {
            this.vote.close(handler);
        }
        if (createdBy != null && !WebSession.getUserId().equals(createdBy)) {
            this.vote.show(handler);
        }
        if (this.pollResults.isOpened()) {
            this.pollResults.updateModel(handler, false, this.room.getClient().hasRight(Room.Right.MODERATOR));
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction(FUNC_QPOLL_ACTION, this.quickPollAction, CallbackParameter.explicit((String)"action"), CallbackParameter.explicit((String)PARAM_VOTE))));
    }

    public boolean isVisible() {
        return this.visible;
    }
}

