/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.dashboard;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.UploadableProfileImagePanel;
import org.apache.openmeetings.web.pages.HashPage;
import org.apache.openmeetings.web.pages.MainPage;
import org.apache.openmeetings.web.util.OmUrlFragment;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.web.WidgetView;

public class WelcomeWidgetView
extends WidgetView {
    private static final long serialVersionUID = 1L;
    @Inject
    private UserDao userDao;
    @Inject
    private PrivateMessageDao msgDao;

    public WelcomeWidgetView(String id, Model<Widget> model) {
        super(id, model);
        User u = this.userDao.get(WebSession.getUserId());
        this.add(new Component[]{new UploadableProfileImagePanel("img", WebSession.getUserId())});
        this.add(new Component[]{new Label("firstname", (IModel)Model.of((Serializable)((Object)u.getFirstname())))});
        this.add(new Component[]{new Label("lastname", (IModel)Model.of((Serializable)((Object)u.getLastname())))});
        this.add(new Component[]{new Label("tz", (IModel)Model.of((Serializable)((Object)u.getTimeZoneId())))});
        this.add(new Component[]{new AjaxLink<Void>("openUnread"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ((MainPage)this.getPage()).updateContents(OmUrlFragment.PROFILE_MESSAGES, (IPartialPageRequestHandler)target);
            }
        }.add(new Component[]{new Label("unread", (IModel)Model.of((Serializable)((Object)String.valueOf(this.msgDao.count(WebSession.getUserId(), PrivateMessage.INBOX_FOLDER_ID, null)))))})});
        this.add(new Component[]{new AjaxLink<Void>("editProfile"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ((MainPage)this.getPage()).updateContents(OmUrlFragment.PROFILE_EDIT, (IPartialPageRequestHandler)target);
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("netTest").add(new Behavior[]{AttributeModifier.append((String)"href", (Serializable)((Object)RequestCycle.get().urlFor(HashPage.class, new PageParameters().add("app", (Object)"network")).toString()))})});
        this.add(new Component[]{new WebMarkupContainer("avTest").add(new Behavior[]{AttributeModifier.append((String)"href", (Serializable)((Object)RequestCycle.get().urlFor(HashPage.class, new PageParameters().add("app", (Object)"settings")).toString()))})});
    }
}

