/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.rooms;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.pages.MainPage;
import org.apache.openmeetings.web.user.rooms.RoomEnterBehavior;
import org.apache.openmeetings.web.util.OmTooltipBehavior;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class RoomListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final ListView<Room> list = new ListView<Room>("list"){
        private static final long serialVersionUID = 1L;

        protected void populateItem(ListItem<Room> item) {
            final Room r = (Room)item.getModelObject();
            Component[] componentArray = new Component[1];
            WebMarkupContainer roomContainer = new WebMarkupContainer("roomContainer");
            componentArray[0] = roomContainer.add(new Behavior[]{new AjaxEventBehavior("click"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    RoomListPanel.this.onContainerClick(target, r);
                }
            }});
            item.add(componentArray);
            roomContainer.add(new Component[]{new Label("roomName", (Serializable)((Object)r.getName()))});
            WebMarkupContainer info = new WebMarkupContainer("info");
            roomContainer.add(new Component[]{info.setOutputMarkupId(true).add(new Behavior[]{AttributeModifier.append((String)"title", (Serializable)((Object)this.getString(String.format("room.type.%s.desc", r.getType().name()))))})});
            final Label curUsers = new Label("curUsers", (IModel)new Model((Serializable)Long.valueOf(RoomListPanel.this.cm.streamByRoom(r.getId()).count())));
            roomContainer.add(new Component[]{curUsers.setOutputMarkupId(true)});
            roomContainer.add(new Component[]{new Label("totalUsers", (Serializable)Long.valueOf(r.getCapacity()))});
            item.add(new Component[]{new WebMarkupContainer("btn").add(new Component[]{new Label("label", (Serializable)((Object)RoomListPanel.this.label))}).add(new Behavior[]{new RoomEnterBehavior(r.getId()){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onEvent(AjaxRequestTarget target) {
                    RoomListPanel.this.onRoomEnter(target, this.roomId);
                }
            }})});
            roomContainer.add(new Component[]{new BootstrapAjaxLink<String>("refresh", null, Buttons.Type.Outline_Info, (IModel)new ResourceModel("lbl.refresh")){
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2, arg3);
                    this.setIconType((IconType)FontAwesome6IconType.rotate_s);
                }

                protected <L extends Serializable> Component newLabel(String markupId, IModel<L> model) {
                    return super.newLabel(markupId, model).setRenderBodyOnly(false).add(new Behavior[]{new CssClassNameAppender(new String[]{"sr-only"})});
                }

                public void onClick(AjaxRequestTarget target) {
                    target.add(new Component[]{curUsers.setDefaultModelObject((Object)RoomListPanel.this.cm.streamByRoom(r.getId()).count())});
                    RoomListPanel.this.onRefreshClick(target, r);
                }
            }.add(new Behavior[]{AttributeModifier.append((String)"title", (IModel)new ResourceModel("lbl.refresh"))})});
        }
    };
    @Inject
    private ClientManager cm;

    public RoomListPanel(String id, List<Room> rooms, String label) {
        super(id);
        this.setOutputMarkupId(true);
        this.label = label;
        this.list.setList(rooms);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.list});
        this.add(new Behavior[]{new OmTooltipBehavior()});
    }

    public void update(IPartialPageRequestHandler handler, List<Room> rooms) {
        this.list.setList(rooms);
        handler.add(new Component[]{this});
    }

    public void onContainerClick(AjaxRequestTarget target, Room r) {
    }

    public void onRefreshClick(AjaxRequestTarget target, Room r) {
    }

    public void onRoomEnter(AjaxRequestTarget target, Long roomId) {
        RoomEnterBehavior.roomEnter((MainPage)this.getPage(), (IPartialPageRequestHandler)target, roomId);
    }
}

