/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static Logger log = LoggerFactory.getLogger(MessageUtils.class);

    public static <R> Response<R> convertResponse(Response<JsonElement> response, Class<R> resultClass) {
        R resultR = MessageUtils.convertJsonTo(response.getResult(), resultClass);
        Response<JsonElement> responseR = response;
        responseR.setResult((JsonElement)resultR);
        return responseR;
    }

    public static <P> Request<P> convertRequest(Request<? extends Object> request, Class<P> paramsClass) {
        Object paramsP = null;
        Object params = request.getParams();
        if (params != null) {
            if (paramsClass.isAssignableFrom(params.getClass())) {
                paramsP = params;
            } else if (params instanceof JsonElement) {
                paramsP = MessageUtils.convertJsonTo((JsonElement)request.getParams(), paramsClass);
            } else {
                throw new ClassCastException();
            }
        }
        Request<? extends Object> requestP = request;
        requestP.setParams(paramsP);
        return requestP;
    }

    private static <R> R convertJsonTo(JsonElement resultElement, Class<R> resultClass) {
        if (resultElement == null) {
            return null;
        }
        if (resultClass == null) {
            return null;
        }
        Object resultR = null;
        if (resultClass == String.class || resultClass == Boolean.class || resultClass == Character.class || Number.class.isAssignableFrom(resultClass) || resultClass.isPrimitive()) {
            Object value;
            if (resultElement.isJsonObject()) {
                JsonObject resultObject = resultElement.getAsJsonObject();
                Set properties = resultObject.entrySet();
                if (properties.size() > 1) {
                    if (resultObject.has("value")) {
                        value = resultObject.get("value");
                    } else {
                        Map.Entry prop = (Map.Entry)properties.iterator().next();
                        log.warn("Converting a result with {} properties into a value of type {}. Selecting property '{}'", new Object[]{properties.size(), resultClass, prop.getKey()});
                        value = (JsonElement)prop.getValue();
                    }
                } else {
                    value = properties.size() == 1 ? (JsonElement)((Map.Entry)properties.iterator().next()).getValue() : null;
                }
            } else if (resultElement.isJsonArray()) {
                JsonArray resultArray = resultElement.getAsJsonArray();
                if (resultArray.size() > 1) {
                    log.warn("Converting an array with {} elements into a value of type {}. Selecting first element", (Object)resultArray.size(), resultClass);
                }
                value = resultArray.get(0);
            } else {
                value = resultElement;
            }
            resultR = JsonUtils.getGson().fromJson(value, resultClass);
        } else {
            resultR = JsonUtils.getGson().fromJson(resultElement, resultClass);
        }
        return (R)resultR;
    }
}

