/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.ArrayList;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.StringList;

public class DefaultPOSContextGenerator
implements POSContextGenerator {
    protected final String SE = "*SE*";
    protected final String SB = "*SB*";
    private static final int PREFIX_LENGTH = 4;
    private static final int SUFFIX_LENGTH = 4;
    private static final Pattern hasCap = Pattern.compile("[A-Z]");
    private static final Pattern hasNum = Pattern.compile("[0-9]");
    private Cache<String, String[]> contextsCache;
    private Object wordsKey;
    private final Dictionary dict;

    public DefaultPOSContextGenerator(Dictionary dict) {
        this(0, dict);
    }

    public DefaultPOSContextGenerator(int cacheSize, Dictionary dict) {
        this.dict = dict;
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    protected static String[] getPrefixes(String lex) {
        String[] prefs = new String[4];
        for (int li = 0; li < 4; ++li) {
            prefs[li] = lex.substring(0, StrictMath.min(li + 1, lex.length()));
        }
        return prefs;
    }

    protected static String[] getSuffixes(String lex) {
        String[] suffs = new String[4];
        for (int li = 0; li < 4; ++li) {
            suffs[li] = lex.substring(StrictMath.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    @Override
    public String[] getContext(int index, String[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, priorDecisions);
    }

    public String[] getContext(int index, Object[] tokens, String[] tags) {
        String prev;
        String next;
        String nextnext = null;
        String prevprev = null;
        String tagprevprev = null;
        String tagprev = null;
        String lex = tokens[index].toString();
        if (tokens.length > index + 1) {
            next = tokens[index + 1].toString();
            nextnext = tokens.length > index + 2 ? tokens[index + 2].toString() : "*SE*";
        } else {
            next = "*SE*";
        }
        if (index - 1 >= 0) {
            prev = tokens[index - 1].toString();
            tagprev = tags[index - 1];
            if (index - 2 >= 0) {
                prevprev = tokens[index - 2].toString();
                tagprevprev = tags[index - 2];
            } else {
                prevprev = "*SB*";
            }
        } else {
            prev = "*SB*";
        }
        String cacheKey = index + tagprev + tagprevprev;
        if (this.contextsCache != null) {
            if (this.wordsKey == tokens) {
                String[] cachedContexts = (String[])this.contextsCache.get(cacheKey);
                if (cachedContexts != null) {
                    return cachedContexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = tokens;
            }
        }
        ArrayList<Object> e = new ArrayList<Object>();
        e.add("default");
        e.add("w=" + lex);
        if (this.dict == null || !this.dict.contains(new StringList(lex))) {
            String[] prefs;
            String[] suffs;
            for (String suff : suffs = DefaultPOSContextGenerator.getSuffixes(lex)) {
                e.add("suf=" + suff);
            }
            for (String pref : prefs = DefaultPOSContextGenerator.getPrefixes(lex)) {
                e.add("pre=" + pref);
            }
            if (lex.indexOf(45) != -1) {
                e.add("h");
            }
            if (hasCap.matcher(lex).find()) {
                e.add("c");
            }
            if (hasNum.matcher(lex).find()) {
                e.add("d");
            }
        }
        if (prev != null) {
            e.add("p=" + prev);
            if (tagprev != null) {
                e.add("t=" + tagprev);
            }
            if (prevprev != null) {
                e.add("pp=" + prevprev);
                if (tagprevprev != null) {
                    e.add("t2=" + tagprevprev + "," + tagprev);
                }
            }
        }
        if (next != null) {
            e.add("n=" + next);
            if (nextnext != null) {
                e.add("nn=" + nextnext);
            }
        }
        String[] contexts = e.toArray(new String[0]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }
}

