/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.event.EventMetadata;
import org.apache.webbeans.util.AnnotationUtil;

public class EventMetadataImpl
implements EventMetadata {
    private final Type type;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifiers;

    public EventMetadataImpl(Type type, InjectionPoint injectionPoint, Annotation ... qualifiers) {
        Set<Annotation> completeQualifiers;
        this.type = type;
        this.injectionPoint = injectionPoint;
        if (qualifiers.length == 0) {
            completeQualifiers = AnnotationUtil.DEFAULT_AND_ANY_ANNOTATION;
        } else {
            completeQualifiers = new HashSet<Annotation>(Arrays.asList(qualifiers));
            if (completeQualifiers.size() != qualifiers.length) {
                throw new IllegalArgumentException("duplicate qualifier");
            }
            if (!completeQualifiers.contains((Object)AnyLiteral.INSTANCE)) {
                completeQualifiers.add((Annotation)((Object)AnyLiteral.INSTANCE));
            }
        }
        this.qualifiers = Collections.unmodifiableSet(completeQualifiers);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }
}

