/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        if (hHeader == null) {
            throw new IOException("Could not get hhea table");
        }
        int numHMetrics = hHeader.getNumberOfHMetrics();
        int numGlyphs = ttf.getNumberOfGlyphs();
        int bytesRead = 0;
        this.advanceWidth = new int[numHMetrics];
        this.leftSideBearing = new short[numHMetrics];
        for (int i = 0; i < numHMetrics; ++i) {
            this.advanceWidth[i] = data.readUnsignedShort();
            this.leftSideBearing[i] = data.readSignedShort();
            bytesRead += 4;
        }
        if ((long)bytesRead < this.getLength()) {
            int numberNonHorizontal = numGlyphs - numHMetrics;
            if (numberNonHorizontal < 0) {
                numberNonHorizontal = numGlyphs;
            }
            this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
            for (int i = 0; i < numberNonHorizontal; ++i) {
                if ((long)bytesRead >= this.getLength()) continue;
                this.nonHorizontalLeftSideBearing[i] = data.readSignedShort();
                bytesRead += 2;
            }
        }
        this.initialized = true;
    }

    public int[] getAdvanceWidth() {
        return this.advanceWidth;
    }

    public void setAdvanceWidth(int[] advanceWidthValue) {
        this.advanceWidth = advanceWidthValue;
    }
}

