/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadingContext;
import org.apache.pdfbox.util.Matrix;

public class AxialShadingContext
extends ShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(AxialShadingContext.class);
    private PDShadingType2 axialShadingType;
    private final float[] coords;
    private final float[] domain;
    private float[] background;
    private int rgbBackground;
    private final boolean[] extend;
    private final double x1x0;
    private final double y1y0;
    private final float d1d0;
    private double denom;
    private final double axialLength;
    private final int[] colorTable;

    public AxialShadingContext(PDShadingType2 shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, pageHeight, dBounds);
        this.axialShadingType = shading;
        this.coords = shading.getCoords().toFloatArray();
        if (ctm != null) {
            ctm.createAffineTransform().transform(this.coords, 0, this.coords, 0, 2);
            this.coords[1] = (float)pageHeight - this.coords[1];
            this.coords[3] = (float)pageHeight - this.coords[3];
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[3] = (float)pageHeight + translateY - this.coords[3];
        }
        xform.transform(this.coords, 0, this.coords, 0, 2);
        this.domain = shading.getDomain() != null ? shading.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        COSArray extendValues = shading.getExtend();
        if (extendValues != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((COSBoolean)extendValues.getObject(0)).getValue();
            this.extend[1] = ((COSBoolean)extendValues.getObject(1)).getValue();
        } else {
            this.extend = new boolean[]{false, false};
        }
        this.x1x0 = this.coords[2] - this.coords[0];
        this.y1y0 = this.coords[3] - this.coords[1];
        this.d1d0 = this.domain[1] - this.domain[0];
        this.denom = Math.pow(this.x1x0, 2.0) + Math.pow(this.y1y0, 2.0);
        this.axialLength = Math.sqrt(this.denom);
        COSArray bg = shading.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
            this.rgbBackground = this.convertToRGB(this.background);
        }
        this.colorTable = this.calcColorTable();
    }

    private int[] calcColorTable() {
        int[] map = new int[(int)this.axialLength + 1];
        if (this.axialLength == 0.0 || this.d1d0 == 0.0f) {
            try {
                float[] values = this.axialShadingType.evalFunction(this.domain[0]);
                map[0] = this.convertToRGB(values);
            }
            catch (IOException exception) {
                LOG.error("error while processing a function", exception);
            }
        } else {
            int i = 0;
            while ((double)i <= this.axialLength) {
                float t = this.domain[0] + this.d1d0 * (float)i / (float)this.axialLength;
                try {
                    float[] values = this.axialShadingType.evalFunction(t);
                    map[i] = this.convertToRGB(values);
                }
                catch (IOException exception) {
                    LOG.error("error while processing a function", exception);
                }
                ++i;
            }
        }
        return map;
    }

    public void dispose() {
        this.outputColorModel = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
        this.axialShadingType = null;
    }

    public ColorModel getColorModel() {
        return this.outputColorModel;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            double currentY = y + j;
            if (this.bboxRect != null && (currentY < (double)this.minBBoxY || currentY > (double)this.maxBBoxY)) continue;
            for (int i = 0; i < w; ++i) {
                int value;
                double currentX = x + i;
                if (this.bboxRect != null && (currentX < (double)this.minBBoxX || currentX > (double)this.maxBBoxX)) continue;
                boolean useBackground = false;
                double inputValue = this.x1x0 * (currentX - (double)this.coords[0]);
                inputValue += this.y1y0 * (currentY - (double)this.coords[1]);
                if (this.denom == 0.0) {
                    if (this.background == null) continue;
                    useBackground = true;
                } else {
                    inputValue /= this.denom;
                }
                if (inputValue < 0.0) {
                    if (this.extend[0]) {
                        inputValue = 0.0;
                    } else {
                        if (this.background == null) continue;
                        useBackground = true;
                    }
                } else if (inputValue > 1.0) {
                    if (this.extend[1]) {
                        inputValue = 1.0;
                    } else {
                        if (this.background == null) continue;
                        useBackground = true;
                    }
                }
                if (useBackground) {
                    value = this.rgbBackground;
                } else {
                    int key = (int)(inputValue * this.axialLength);
                    value = this.colorTable[key];
                }
                int index = (j * w + i) * 4;
                data[index] = value & 0xFF;
                data[index + 1] = (value >>= 8) & 0xFF;
                data[index + 2] = (value >>= 8) & 0xFF;
                data[index + 3] = 255;
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    public float[] getCoords() {
        return this.coords;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public boolean[] getExtend() {
        return this.extend;
    }

    public PDFunction getFunction() throws IOException {
        return this.axialShadingType.getFunction();
    }
}

