/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.CIDToGIDMap;
import org.apache.pdfbox.preflight.utils.COSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescendantFontValidator<T extends FontContainer>
extends SimpleFontValidator<T> {
    protected COSDocument cosDocument = null;

    public DescendantFontValidator(PreflightContext context, PDFont font, T fContainer) {
        super(context, font, fContainer);
        this.cosDocument = context.getDocument().getDocument();
    }

    @Override
    protected void checkMandatoryField() {
        COSDictionary fontDictionary = (COSDictionary)this.font.getCOSObject();
        boolean arePresent = fontDictionary.containsKey(COSName.TYPE);
        arePresent &= fontDictionary.containsKey(COSName.SUBTYPE);
        arePresent &= fontDictionary.containsKey(COSName.BASE_FONT);
        arePresent &= fontDictionary.containsKey(COSName.CIDSYSTEMINFO);
        if (!(arePresent &= fontDictionary.containsKey(COSName.FONT_DESC))) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.1", "Required keys are missing"));
        }
        this.checkCIDSystemInfo(fontDictionary.getItem(COSName.CIDSYSTEMINFO));
        this.checkCIDToGIDMap(fontDictionary.getItem(COSName.CID_TO_GID_MAP));
    }

    protected void checkCIDSystemInfo(COSBase sysinfo) {
        COSDictionary cidSysInfo = COSUtils.getAsDictionary(sysinfo, this.cosDocument);
        if (cidSysInfo != null) {
            COSBase reg = cidSysInfo.getItem(COSName.REGISTRY);
            COSBase ord = cidSysInfo.getItem(COSName.ORDERING);
            COSBase sup = cidSysInfo.getItem(COSName.SUPPLEMENT);
            if (!(COSUtils.isString(reg, this.cosDocument) && COSUtils.isString(ord, this.cosDocument) && COSUtils.isInteger(sup, this.cosDocument))) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
            }
        } else {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
        }
    }

    protected abstract void checkCIDToGIDMap(COSBase var1);

    protected CIDToGIDMap checkCIDToGIDMap(COSBase ctog, boolean mandatory) {
        CIDToGIDMap cidToGidMap = null;
        if (COSUtils.isString(ctog, this.cosDocument)) {
            String ctogStr = COSUtils.getAsString(ctog, this.cosDocument);
            if (!"Identity".equals(ctogStr)) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", "The CIDToGID entry is invalid"));
            }
        } else if (COSUtils.isStream(ctog, this.cosDocument)) {
            try {
                COSStream ctogMap = COSUtils.getAsStream(ctog, this.cosDocument);
                cidToGidMap = new CIDToGIDMap();
                cidToGidMap.parseStream(ctogMap);
            }
            catch (IOException e) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9"));
            }
        } else if (mandatory) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.9"));
        }
        return cidToGidMap;
    }
}

