/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.util.io.Streams;

public class CMSTypedStream {
    private static final int BUF_SIZ = 32768;
    private final String _oid;
    private final InputStream _in;

    public CMSTypedStream(InputStream inputStream) {
        this(PKCSObjectIdentifiers.data.getId(), inputStream, 32768);
    }

    public CMSTypedStream(String string, InputStream inputStream) {
        this(string, inputStream, 32768);
    }

    public CMSTypedStream(String string, InputStream inputStream, int n) {
        this._oid = string;
        this._in = new FullReaderStream(inputStream, n);
    }

    public String getContentType() {
        return this._oid;
    }

    public InputStream getContentStream() {
        return this._in;
    }

    public void drain() throws IOException {
        Streams.drain(this._in);
        this._in.close();
    }

    private class FullReaderStream
    extends InputStream {
        InputStream _stream;

        FullReaderStream(InputStream inputStream, int n) {
            this._stream = new BufferedInputStream(inputStream, n);
        }

        public int read() throws IOException {
            return this._stream.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 0;
            while (n2 != 0 && (n3 = this._stream.read(byArray, n, n2)) > 0) {
                n += n3;
                n2 -= n3;
                n4 += n3;
            }
            if (n4 > 0) {
                return n4;
            }
            return -1;
        }

        public void close() throws IOException {
            this._stream.close();
        }
    }
}

