/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.utils.COSUtils;

public abstract class DescendantFontValidator<T extends FontContainer>
extends SimpleFontValidator<T> {
    protected COSDocument cosDocument = null;

    public DescendantFontValidator(PreflightContext context, PDCIDFont font, T fContainer) {
        super(context, (PDFontLike)font, font.getCOSObject(), fContainer);
        this.cosDocument = context.getDocument().getDocument();
    }

    @Override
    protected void checkMandatoryField() {
        boolean arePresent = this.fontDictionary.containsKey(COSName.TYPE);
        arePresent &= this.fontDictionary.containsKey(COSName.SUBTYPE);
        arePresent &= this.fontDictionary.containsKey(COSName.BASE_FONT);
        arePresent &= this.fontDictionary.containsKey(COSName.CIDSYSTEMINFO);
        if (!(arePresent &= this.fontDictionary.containsKey(COSName.FONT_DESC))) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Required keys are missing"));
        }
        this.checkCIDSystemInfo(this.fontDictionary.getItem(COSName.CIDSYSTEMINFO));
        this.checkCIDToGIDMap(this.fontDictionary.getItem(COSName.CID_TO_GID_MAP));
    }

    protected void checkCIDSystemInfo(COSBase sysinfo) {
        COSDictionary cidSysInfo = COSUtils.getAsDictionary(sysinfo, this.cosDocument);
        if (cidSysInfo != null) {
            COSBase reg = cidSysInfo.getItem(COSName.REGISTRY);
            COSBase ord = cidSysInfo.getItem(COSName.ORDERING);
            COSBase sup = cidSysInfo.getItem(COSName.SUPPLEMENT);
            if (!(COSUtils.isString(reg, this.cosDocument) && COSUtils.isString(ord, this.cosDocument) && COSUtils.isInteger(sup, this.cosDocument))) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
            }
        } else {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.8"));
        }
    }

    protected abstract void checkCIDToGIDMap(COSBase var1);

    protected void checkCIDToGIDMap(COSBase ctog, boolean mandatory) {
        if (COSUtils.isString(ctog, this.cosDocument)) {
            String ctogStr = COSUtils.getAsString(ctog, this.cosDocument);
            if (!"Identity".equals(ctogStr)) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": The CIDToGID entry is invalid"));
            }
        } else if (COSUtils.isStream(ctog, this.cosDocument)) {
            try {
                COSStream stream = COSUtils.getAsStream(ctog, this.cosDocument);
                COSInputStream is = stream.createInputStream();
                is.close();
            }
            catch (IOException e) {
                this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": error getting CIDToGIDMap", e));
            }
        } else if (mandatory) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.9", this.font.getName() + ": mandatory CIDToGIDMap missing"));
        }
    }
}

