/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDSimpleFileSpecification;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationCaret;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationCircle;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationFreeText;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationHighlight;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationInk;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationLine;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationLink;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationPolygon;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationPolyline;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationSound;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationSquare;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationSquiggly;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationStamp;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationStrikeOut;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationText;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationUnderline;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.fdf.FDFJavaScript;
import org.apache.pdfbox.pdmodel.fdf.FDFPage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFDictionary
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(FDFDictionary.class);
    private final COSDictionary fdf;

    public FDFDictionary() {
        this.fdf = new COSDictionary();
    }

    public FDFDictionary(COSDictionary fdfDictionary) {
        this.fdf = fdfDictionary;
    }

    public FDFDictionary(Element fdfXML) {
        this();
        NodeList nodeList = fdfXML.getChildNodes();
        block58: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            switch (child.getTagName()) {
                case "f": {
                    PDSimpleFileSpecification fs = new PDSimpleFileSpecification();
                    fs.setFile(child.getAttribute("href"));
                    this.setFile(fs);
                    continue block58;
                }
                case "ids": {
                    COSArray ids = new COSArray();
                    String original = child.getAttribute("original");
                    String modified = child.getAttribute("modified");
                    try {
                        ids.add(COSString.parseHex(original));
                    }
                    catch (IOException e) {
                        LOG.warn("Error parsing ID entry for attribute 'original' [" + original + "]. ID entry ignored.", e);
                    }
                    try {
                        ids.add(COSString.parseHex(modified));
                    }
                    catch (IOException e) {
                        LOG.warn("Error parsing ID entry for attribute 'modified' [" + modified + "]. ID entry ignored.", e);
                    }
                    this.setID(ids);
                    continue block58;
                }
                case "fields": {
                    NodeList fields = child.getChildNodes();
                    ArrayList<FDFField> fieldList = new ArrayList<FDFField>();
                    for (int f = 0; f < fields.getLength(); ++f) {
                        Node currentNode = fields.item(f);
                        if (!(currentNode instanceof Element) || !((Element)currentNode).getTagName().equals("field")) continue;
                        try {
                            fieldList.add(new FDFField((Element)fields.item(f)));
                            continue;
                        }
                        catch (IOException e) {
                            LOG.warn("Error parsing field entry [" + currentNode.getNodeValue() + "]. Field ignored.", e);
                        }
                    }
                    this.setFields(fieldList);
                    continue block58;
                }
                case "annots": {
                    NodeList annots = child.getChildNodes();
                    ArrayList<FDFAnnotation> annotList = new ArrayList<FDFAnnotation>();
                    for (int j = 0; j < annots.getLength(); ++j) {
                        Node annotNode = annots.item(j);
                        if (!(annotNode instanceof Element)) continue;
                        Element annot = (Element)annotNode;
                        String annotationName = annot.getNodeName();
                        try {
                            switch (annotationName) {
                                case "text": {
                                    annotList.add(new FDFAnnotationText(annot));
                                    break;
                                }
                                case "caret": {
                                    annotList.add(new FDFAnnotationCaret(annot));
                                    break;
                                }
                                case "freetext": {
                                    annotList.add(new FDFAnnotationFreeText(annot));
                                    break;
                                }
                                case "fileattachment": {
                                    annotList.add(new FDFAnnotationFileAttachment(annot));
                                    break;
                                }
                                case "highlight": {
                                    annotList.add(new FDFAnnotationHighlight(annot));
                                    break;
                                }
                                case "ink": {
                                    annotList.add(new FDFAnnotationInk(annot));
                                    break;
                                }
                                case "line": {
                                    annotList.add(new FDFAnnotationLine(annot));
                                    break;
                                }
                                case "link": {
                                    annotList.add(new FDFAnnotationLink(annot));
                                    break;
                                }
                                case "circle": {
                                    annotList.add(new FDFAnnotationCircle(annot));
                                    break;
                                }
                                case "square": {
                                    annotList.add(new FDFAnnotationSquare(annot));
                                    break;
                                }
                                case "polygon": {
                                    annotList.add(new FDFAnnotationPolygon(annot));
                                    break;
                                }
                                case "polyline": {
                                    annotList.add(new FDFAnnotationPolyline(annot));
                                    break;
                                }
                                case "sound": {
                                    annotList.add(new FDFAnnotationSound(annot));
                                    break;
                                }
                                case "squiggly": {
                                    annotList.add(new FDFAnnotationSquiggly(annot));
                                    break;
                                }
                                case "stamp": {
                                    annotList.add(new FDFAnnotationStamp(annot));
                                    break;
                                }
                                case "strikeout": {
                                    annotList.add(new FDFAnnotationStrikeOut(annot));
                                    break;
                                }
                                case "underline": {
                                    annotList.add(new FDFAnnotationUnderline(annot));
                                    break;
                                }
                                default: {
                                    LOG.warn("Unknown or unsupported annotation type '" + annotationName + "'");
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (IOException e) {
                            LOG.warn("Error parsing annotation information [" + annot.getNodeValue() + "]. Annotation ignored", e);
                        }
                    }
                    this.setAnnotations(annotList);
                    continue block58;
                }
            }
        }
    }

    public void writeXML(Writer output) throws IOException {
        List<FDFField> fields;
        COSArray ids;
        PDFileSpecification fs = this.getFile();
        if (fs != null) {
            output.write("<f href=\"" + fs.getFile() + "\" />\n");
        }
        if ((ids = this.getID()) != null) {
            COSString original = (COSString)ids.getObject(0);
            COSString modified = (COSString)ids.getObject(1);
            output.write("<ids original=\"" + original.toHexString() + "\" ");
            output.write("modified=\"" + modified.toHexString() + "\" />\n");
        }
        if ((fields = this.getFields()) != null && fields.size() > 0) {
            output.write("<fields>\n");
            for (FDFField field : fields) {
                field.writeXML(output);
            }
            output.write("</fields>\n");
        }
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.fdf;
    }

    public PDFileSpecification getFile() throws IOException {
        return PDFileSpecification.createFS(this.fdf.getDictionaryObject(COSName.F));
    }

    public final void setFile(PDFileSpecification fs) {
        this.fdf.setItem(COSName.F, (COSObjectable)fs);
    }

    public COSArray getID() {
        return this.fdf.getCOSArray(COSName.ID);
    }

    public final void setID(COSArray id) {
        this.fdf.setItem(COSName.ID, (COSBase)id);
    }

    public List<FDFField> getFields() {
        COSArrayList retval = null;
        COSArray fieldArray = this.fdf.getCOSArray(COSName.FIELDS);
        if (fieldArray != null) {
            ArrayList<FDFField> fields = new ArrayList<FDFField>(fieldArray.size());
            for (int i = 0; i < fieldArray.size(); ++i) {
                fields.add(new FDFField((COSDictionary)fieldArray.getObject(i)));
            }
            retval = new COSArrayList(fields, fieldArray);
        }
        return retval;
    }

    public final void setFields(List<FDFField> fields) {
        this.fdf.setItem(COSName.FIELDS, (COSBase)new COSArray(fields));
    }

    public String getStatus() {
        return this.fdf.getString(COSName.STATUS);
    }

    public void setStatus(String status) {
        this.fdf.setString(COSName.STATUS, status);
    }

    public List<FDFPage> getPages() {
        COSArrayList retval = null;
        COSArray pageArray = this.fdf.getCOSArray(COSName.PAGES);
        if (pageArray != null) {
            ArrayList<FDFPage> pages = new ArrayList<FDFPage>(pageArray.size());
            for (int i = 0; i < pageArray.size(); ++i) {
                pages.add(new FDFPage((COSDictionary)pageArray.get(i)));
            }
            retval = new COSArrayList(pages, pageArray);
        }
        return retval;
    }

    public void setPages(List<FDFPage> pages) {
        this.fdf.setItem(COSName.PAGES, (COSBase)new COSArray(pages));
    }

    public String getEncoding() {
        String encoding = this.fdf.getNameAsString(COSName.ENCODING);
        if (encoding == null) {
            encoding = "PDFDocEncoding";
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.fdf.setName(COSName.ENCODING, encoding);
    }

    public List<FDFAnnotation> getAnnotations() throws IOException {
        COSArrayList retval = null;
        COSArray annotArray = this.fdf.getCOSArray(COSName.ANNOTS);
        if (annotArray != null) {
            ArrayList<FDFAnnotation> annots = new ArrayList<FDFAnnotation>(annotArray.size());
            for (int i = 0; i < annotArray.size(); ++i) {
                annots.add(FDFAnnotation.create((COSDictionary)annotArray.getObject(i)));
            }
            retval = new COSArrayList(annots, annotArray);
        }
        return retval;
    }

    public final void setAnnotations(List<FDFAnnotation> annots) {
        this.fdf.setItem(COSName.ANNOTS, (COSBase)new COSArray(annots));
    }

    public COSStream getDifferences() {
        return this.fdf.getCOSStream(COSName.DIFFERENCES);
    }

    public void setDifferences(COSStream diff) {
        this.fdf.setItem(COSName.DIFFERENCES, (COSBase)diff);
    }

    public String getTarget() {
        return this.fdf.getString(COSName.TARGET);
    }

    public void setTarget(String target) {
        this.fdf.setString(COSName.TARGET, target);
    }

    public List<PDFileSpecification> getEmbeddedFDFs() throws IOException {
        COSArrayList retval = null;
        COSArray embeddedArray = this.fdf.getCOSArray(COSName.EMBEDDED_FDFS);
        if (embeddedArray != null) {
            ArrayList<PDFileSpecification> embedded = new ArrayList<PDFileSpecification>(embeddedArray.size());
            for (int i = 0; i < embeddedArray.size(); ++i) {
                embedded.add(PDFileSpecification.createFS(embeddedArray.get(i)));
            }
            retval = new COSArrayList(embedded, embeddedArray);
        }
        return retval;
    }

    public void setEmbeddedFDFs(List<PDFileSpecification> embedded) {
        this.fdf.setItem(COSName.EMBEDDED_FDFS, (COSBase)new COSArray(embedded));
    }

    public FDFJavaScript getJavaScript() {
        COSDictionary dic = this.fdf.getCOSDictionary(COSName.JAVA_SCRIPT);
        return dic != null ? new FDFJavaScript(dic) : null;
    }

    public void setJavaScript(FDFJavaScript js) {
        this.fdf.setItem(COSName.JAVA_SCRIPT, (COSObjectable)js);
    }
}

