/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.DataInputByteArray;

public class Type1CharStringParser {
    private static final Log LOG = LogFactory.getLog(Type1CharStringParser.class);
    private static final int CALLSUBR = 10;
    private static final int TWO_BYTE = 12;
    private static final int CALLOTHERSUBR = 16;
    private static final int POP = 17;
    private final String fontName;
    private String currentGlyph;

    public Type1CharStringParser(String fontName) {
        this.fontName = fontName;
    }

    public List<Object> parse(byte[] bytes, List<byte[]> subrs, String glyphName) throws IOException {
        this.currentGlyph = glyphName;
        return this.parse(bytes, subrs, new ArrayList<Object>());
    }

    private List<Object> parse(byte[] bytes, List<byte[]> subrs, List<Object> sequence) throws IOException {
        DataInputByteArray input = new DataInputByteArray(bytes);
        while (input.hasRemaining()) {
            int b0 = input.readUnsignedByte();
            if (b0 == 10) {
                this.processCallSubr(subrs, sequence);
                continue;
            }
            if (b0 == 12 && input.peekUnsignedByte(0) == 16) {
                this.processCallOtherSubr(input, sequence);
                continue;
            }
            if (b0 >= 0 && b0 <= 31) {
                sequence.add(this.readCommand(input, b0));
                continue;
            }
            if (b0 >= 32 && b0 <= 255) {
                sequence.add(this.readNumber(input, b0));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return sequence;
    }

    private void processCallSubr(List<byte[]> subrs, List<Object> sequence) throws IOException {
        Object obj = sequence.remove(sequence.size() - 1);
        if (!(obj instanceof Integer)) {
            LOG.warn("Parameter " + obj + " for CALLSUBR is ignored, integer expected in glyph '" + this.currentGlyph + "' of font " + this.fontName);
            return;
        }
        int operand = (Integer)obj;
        if (operand >= 0 && operand < subrs.size()) {
            byte[] subrBytes = subrs.get(operand);
            this.parse(subrBytes, subrs, sequence);
            Object lastItem = sequence.get(sequence.size() - 1);
            if (lastItem instanceof CharStringCommand && CharStringCommand.Type1KeyWord.RET == ((CharStringCommand)lastItem).getType1KeyWord()) {
                sequence.remove(sequence.size() - 1);
            }
        } else {
            LOG.warn("CALLSUBR is ignored, operand: " + operand + ", subrs.size(): " + subrs.size() + " in glyph '" + this.currentGlyph + "' of font " + this.fontName);
            while (sequence.get(sequence.size() - 1) instanceof Integer) {
                sequence.remove(sequence.size() - 1);
            }
        }
    }

    private void processCallOtherSubr(DataInput input, List<Object> sequence) throws IOException {
        input.readByte();
        Integer othersubrNum = (Integer)sequence.remove(sequence.size() - 1);
        Integer numArgs = (Integer)sequence.remove(sequence.size() - 1);
        ArrayDeque<Integer> results = new ArrayDeque<Integer>();
        switch (othersubrNum) {
            case 0: {
                results.push(Type1CharStringParser.removeInteger(sequence));
                results.push(Type1CharStringParser.removeInteger(sequence));
                sequence.remove(sequence.size() - 1);
                sequence.add(0);
                sequence.add(CharStringCommand.COMMAND_CALLOTHERSUBR);
                break;
            }
            case 1: {
                sequence.add(1);
                sequence.add(CharStringCommand.COMMAND_CALLOTHERSUBR);
                break;
            }
            case 3: {
                results.push(Type1CharStringParser.removeInteger(sequence));
                break;
            }
            default: {
                for (int i = 0; i < numArgs; ++i) {
                    results.push(Type1CharStringParser.removeInteger(sequence));
                }
            }
        }
        while (input.peekUnsignedByte(0) == 12 && input.peekUnsignedByte(1) == 17) {
            input.readByte();
            input.readByte();
            sequence.add(results.pop());
        }
        if (!results.isEmpty()) {
            LOG.warn("Value left on the PostScript stack in glyph " + this.currentGlyph + " of font " + this.fontName);
        }
    }

    private static Integer removeInteger(List<Object> sequence) throws IOException {
        Object item = sequence.remove(sequence.size() - 1);
        if (item instanceof Integer) {
            return (Integer)item;
        }
        CharStringCommand command = (CharStringCommand)item;
        if (CharStringCommand.Type1KeyWord.DIV == command.getType1KeyWord()) {
            int a = (Integer)sequence.remove(sequence.size() - 1);
            int b = (Integer)sequence.remove(sequence.size() - 1);
            return b / a;
        }
        throw new IOException("Unexpected char string command: " + (Object)((Object)command.getType1KeyWord()));
    }

    private CharStringCommand readCommand(DataInput input, int b0) throws IOException {
        if (b0 == 12) {
            int b1 = input.readUnsignedByte();
            return CharStringCommand.getInstance(b0, b1);
        }
        return CharStringCommand.getInstance(b0);
    }

    private Integer readNumber(DataInput input, int b0) throws IOException {
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 255) {
            return input.readInt();
        }
        throw new IllegalArgumentException();
    }
}

