/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariablePassword is an enum
type OpcuaNodeIdServicesVariablePassword int32

type IOpcuaNodeIdServicesVariablePassword interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariablePassword_PasswordOptionsMask_OptionSetValues OpcuaNodeIdServicesVariablePassword = 24278
)

var OpcuaNodeIdServicesVariablePasswordValues []OpcuaNodeIdServicesVariablePassword

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariablePasswordValues = []OpcuaNodeIdServicesVariablePassword{
		OpcuaNodeIdServicesVariablePassword_PasswordOptionsMask_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariablePasswordByValue(value int32) (enum OpcuaNodeIdServicesVariablePassword, ok bool) {
	switch value {
	case 24278:
		return OpcuaNodeIdServicesVariablePassword_PasswordOptionsMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePasswordByName(value string) (enum OpcuaNodeIdServicesVariablePassword, ok bool) {
	switch value {
	case "PasswordOptionsMask_OptionSetValues":
		return OpcuaNodeIdServicesVariablePassword_PasswordOptionsMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariablePasswordKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariablePasswordValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariablePassword(structType any) OpcuaNodeIdServicesVariablePassword {
	castFunc := func(typ any) OpcuaNodeIdServicesVariablePassword {
		if sOpcuaNodeIdServicesVariablePassword, ok := typ.(OpcuaNodeIdServicesVariablePassword); ok {
			return sOpcuaNodeIdServicesVariablePassword
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariablePassword) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariablePassword) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariablePasswordParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariablePassword, error) {
	return OpcuaNodeIdServicesVariablePasswordParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariablePasswordParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariablePassword, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariablePassword", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariablePassword")
	}
	if enum, ok := OpcuaNodeIdServicesVariablePasswordByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariablePassword")
		return OpcuaNodeIdServicesVariablePassword(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariablePassword) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariablePassword) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariablePassword", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariablePassword) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariablePassword) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariablePassword_PasswordOptionsMask_OptionSetValues:
		return "PasswordOptionsMask_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariablePassword) String() string {
	return e.PLC4XEnumName()
}
