/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum AirConditioningCommandType {
  SET_ZONE_GROUP_OFF((byte) 0x00, (short) 0),
  ZONE_HVAC_PLANT_STATUS((byte) 0x01, (short) 5),
  ZONE_HUMIDITY_PLANT_STATUS((byte) 0x02, (short) 5),
  ZONE_TEMPERATURE((byte) 0x03, (short) 4),
  ZONE_HUMIDITY((byte) 0x04, (short) 4),
  REFRESH((byte) 0x05, (short) 1),
  SET_ZONE_HVAC_MODE((byte) 0x06, (short) 5),
  SET_PLANT_HVAC_LEVEL((byte) 0x07, (short) 5),
  SET_ZONE_HUMIDITY_MODE((byte) 0x08, (short) 5),
  SET_PLANT_HUMIDITY_LEVEL((byte) 0x09, (short) 5),
  SET_HVAC_UPPER_GUARD_LIMIT((byte) 0x0A, (short) 4),
  SET_HVAC_LOWER_GUARD_LIMIT((byte) 0x0B, (short) 4),
  SET_HVAC_SETBACK_LIMIT((byte) 0x0C, (short) 4),
  SET_HUMIDITY_UPPER_GUARD_LIMIT((byte) 0x0D, (short) 4),
  SET_HUMIDITY_LOWER_GUARD_LIMIT((byte) 0x0E, (short) 4),
  SET_ZONE_GROUP_ON((byte) 0x0F, (short) 1),
  SET_HUMIDITY_SETBACK_LIMIT((byte) 0x10, (short) 1),
  HVAC_SCHEDULE_ENTRY((byte) 0x11, (short) 7),
  HUMIDITY_SCHEDULE_ENTRY((byte) 0x12, (short) 7);
  private static final Map<Byte, AirConditioningCommandType> map;

  static {
    map = new HashMap<>();
    for (AirConditioningCommandType value : AirConditioningCommandType.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final short numberOfArguments;

  AirConditioningCommandType(byte value, short numberOfArguments) {
    this.value = value;
    this.numberOfArguments = numberOfArguments;
  }

  public byte getValue() {
    return value;
  }

  public short getNumberOfArguments() {
    return numberOfArguments;
  }

  public static AirConditioningCommandType firstEnumForFieldNumberOfArguments(short fieldValue) {
    for (AirConditioningCommandType _val : AirConditioningCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<AirConditioningCommandType> enumsForFieldNumberOfArguments(short fieldValue) {
    List<AirConditioningCommandType> _values = new ArrayList<>();
    for (AirConditioningCommandType _val : AirConditioningCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static AirConditioningCommandType enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
