/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableBase {
  BaseEventType_EventId((int) 2042L),
  BaseEventType_EventType((int) 2043L),
  BaseEventType_SourceNode((int) 2044L),
  BaseEventType_SourceName((int) 2045L),
  BaseEventType_Time((int) 2046L),
  BaseEventType_ReceiveTime((int) 2047L),
  BaseEventType_Message((int) 2050L),
  BaseEventType_Severity((int) 2051L),
  BaseEventType_LocalTime((int) 3190L),
  BaseAnalogType_InstrumentRange((int) 17567L),
  BaseAnalogType_EURange((int) 17568L),
  BaseAnalogType_EngineeringUnits((int) 17569L),
  BaseLogEventType_ConditionClassId((int) 19363L),
  BaseLogEventType_ConditionClassName((int) 19364L),
  BaseLogEventType_ErrorCode((int) 19365L),
  BaseLogEventType_ErrorCodeNode((int) 19366L),
  BaseEventType_ConditionClassId((int) 31771L),
  BaseEventType_ConditionClassName((int) 31772L),
  BaseEventType_ConditionSubClassId((int) 31773L),
  BaseEventType_ConditionSubClassName((int) 31774L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableBase> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableBase value : OpcuaNodeIdServicesVariableBase.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableBase(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableBase enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
