/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.AarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TypeSolverBuilder {
    private final List<TypeSolver> typeSolvers = new ArrayList<TypeSolver>();

    public TypeSolverBuilder with(@NonNull TypeSolver typeSolver) {
        Preconditions.checkNotNull((Object)typeSolver, (Object)"The typeSolver can't be null!");
        this.typeSolvers.add(typeSolver);
        return this;
    }

    public TypeSolverBuilder withCurrentJRE() {
        ReflectionTypeSolver javaRuntime = new ReflectionTypeSolver();
        return this.with(javaRuntime);
    }

    public TypeSolverBuilder withCurrentClassloader() {
        ReflectionTypeSolver classLoaderTypeSolver = new ReflectionTypeSolver(false);
        return this.with(classLoaderTypeSolver);
    }

    public TypeSolverBuilder withJAR(@NonNull Path pathToJar) throws IOException {
        JarTypeSolver jarTypeSolver = new JarTypeSolver(pathToJar);
        return this.with(jarTypeSolver);
    }

    public TypeSolverBuilder withJAR(@NonNull File pathToJar) throws IOException {
        JarTypeSolver jarTypeSolver = new JarTypeSolver(pathToJar);
        return this.with(jarTypeSolver);
    }

    public TypeSolverBuilder withJAR(@NonNull String pathToJar) throws IOException {
        JarTypeSolver jarTypeSolver = new JarTypeSolver(pathToJar);
        return this.with(jarTypeSolver);
    }

    public TypeSolverBuilder withAAR(@NonNull Path pathToAar) throws IOException {
        AarTypeSolver aarTypeSolver = new AarTypeSolver(pathToAar);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withAAR(@NonNull File pathToAar) throws IOException {
        AarTypeSolver aarTypeSolver = new AarTypeSolver(pathToAar);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withAAR(@NonNull String pathToAar) throws IOException {
        AarTypeSolver aarTypeSolver = new AarTypeSolver(pathToAar);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withSourceCode(@NonNull Path pathToSourceCode) {
        JavaParserTypeSolver aarTypeSolver = new JavaParserTypeSolver(pathToSourceCode);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withSourceCode(@NonNull File pathToSourceCode) {
        JavaParserTypeSolver aarTypeSolver = new JavaParserTypeSolver(pathToSourceCode);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withSourceCode(@NonNull String pathToSourceCode) {
        JavaParserTypeSolver aarTypeSolver = new JavaParserTypeSolver(pathToSourceCode);
        return this.with(aarTypeSolver);
    }

    public TypeSolverBuilder withClassLoader(@NonNull ClassLoader classLoader) {
        ClassLoaderTypeSolver classLoaderTypeSolver = new ClassLoaderTypeSolver(classLoader);
        return this.with(classLoaderTypeSolver);
    }

    public TypeSolver build() {
        int typeSolversCount = this.typeSolvers.size();
        if (typeSolversCount == 0) {
            throw new IllegalStateException("At least a type solver is expected.");
        }
        if (typeSolversCount == 1) {
            return this.typeSolvers.get(0);
        }
        return new CombinedTypeSolver(this.typeSolvers);
    }
}

