/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method getElementsByTagNameNS returns a NodeList of all the Elements with a given local
 * name and namespace URI in the order in which they are encountered in a preorder traversal
 * of the Document tree.
 * Invoke getElementsByTagNameNS on the documentElement with values for namespaceURI '*' and
 * localName '*'.  Verify if this returns a nodeList of 0 elements.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getElBTNNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getElBTNNS</a>
 */
public class elementgetelementsbytagnamens02 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", false);
        Element element = doc.getDocumentElement();
        NodeList elementList = element.getElementsByTagNameNS("**", "*");
        assertEquals(0, elementList.getLength(), "elementgetelementsbytagnamens02");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementgetelementsbytagnamens02";
    }

}
