/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;

public class ProtobufNativeRecordBuilderImpl
implements GenericRecordBuilder {
    private GenericProtobufNativeSchema genericSchema;
    private DynamicMessage.Builder builder;
    private Descriptors.Descriptor msgDesc;

    public ProtobufNativeRecordBuilderImpl(GenericProtobufNativeSchema genericSchema) {
        this.genericSchema = genericSchema;
        this.msgDesc = genericSchema.getProtobufNativeSchema();
        this.builder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.msgDesc);
    }

    public GenericRecordBuilder set(String fieldName, Object value) {
        this.builder.setField(this.msgDesc.findFieldByName(fieldName), value);
        return this;
    }

    public GenericRecordBuilder set(Field field, Object value) {
        this.builder.setField(this.msgDesc.findFieldByName(field.getName()), value);
        return this;
    }

    public GenericRecordBuilder clear(String fieldName) {
        this.builder.clearField(this.msgDesc.findFieldByName(fieldName));
        return this;
    }

    public GenericRecordBuilder clear(Field field) {
        this.builder.clearField(this.msgDesc.findFieldByName(field.getName()));
        return this;
    }

    public GenericRecord build() {
        return new GenericProtobufNativeRecord(null, this.genericSchema.getProtobufNativeSchema(), this.genericSchema.getFields(), this.builder.build());
    }
}

