/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import tools.jackson.core.FormatFeature;

public enum JsonWriteFeature implements FormatFeature
{
    QUOTE_PROPERTY_NAMES(true),
    WRITE_NAN_AS_STRINGS(true),
    COMBINE_UNICODE_SURROGATES_IN_UTF8(true),
    ESCAPE_FORWARD_SLASHES(false),
    ESCAPE_NON_ASCII(false),
    WRITE_HEX_UPPER_CASE(true),
    WRITE_NUMBERS_AS_STRINGS(false);

    private final boolean _defaultState;
    private final int _mask;

    public static int collectDefaults() {
        int flags = 0;
        for (JsonWriteFeature f : JsonWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    private JsonWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1 << this.ordinal();
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public int getMask() {
        return this._mask;
    }

    @Override
    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }
}

