/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import javax.security.auth.Subject;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.SessionInvalidatedException;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SaslServlet.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String ATTR_RANDOM = "SaslServlet.Random";
    private static final String ATTR_ID = "SaslServlet.ID";
    private static final String ATTR_SASL_NEGOTIATOR = "SaslServlet.SaslNegotiator";
    private static final String ATTR_EXPIRY = "SaslServlet.Expiry";

    @Override
    protected final void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        this.getRandom(request);
        AuthenticationProvider<?> authenticationProvider = this.getAuthenticationProvider(request);
        List mechanismsList = authenticationProvider.getAvailableMechanisms(request.isSecure());
        String[] mechanisms = mechanismsList.toArray(new String[mechanismsList.size()]);
        LinkedHashMap<String, Object> outputObject = new LinkedHashMap<String, Object>();
        Subject subject = Subject.getSubject(AccessController.getContext());
        AuthenticatedPrincipal principal = AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject((Subject)subject);
        if (principal != null) {
            outputObject.put("user", principal.getName());
        } else if (request.getRemoteUser() != null) {
            outputObject.put("user", request.getRemoteUser());
        }
        outputObject.put("mechanisms", mechanisms);
        this.sendJsonResponse(outputObject, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Random getRandom(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Random rand = (Random)HttpManagementUtil.getSessionAttribute(ATTR_RANDOM, session, request);
        if (rand == null) {
            SecureRandom secureRandom = SECURE_RANDOM;
            synchronized (secureRandom) {
                rand = new Random(SECURE_RANDOM.nextLong());
            }
            HttpManagementUtil.setSessionAttribute(ATTR_RANDOM, rand, session, request);
        }
        return rand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(final HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException {
        this.checkSaslAuthEnabled(request);
        HttpSession session = request.getSession();
        try {
            String mechanism = request.getParameter("mechanism");
            String id = request.getParameter("id");
            String saslResponse = request.getParameter("response");
            SubjectCreator subjectCreator = this.getSubjectCreator(request);
            AuthenticationProvider<?> authenticationProvider = this.getAuthenticationProvider(request);
            SaslNegotiator saslNegotiator = null;
            if (mechanism != null) {
                if (id == null && authenticationProvider.getAvailableMechanisms(request.isSecure()).contains(mechanism)) {
                    LOGGER.debug("Creating SaslServer for mechanism: {}", (Object)mechanism);
                    saslNegotiator = subjectCreator.createSaslNegotiator(mechanism, new SaslSettings(){

                        public String getLocalFQDN() {
                            return request.getServerName();
                        }

                        public Principal getExternalPrincipal() {
                            return null;
                        }
                    });
                }
            } else if (id != null && id.equals(HttpManagementUtil.getSessionAttribute(ATTR_ID, session, request)) && System.currentTimeMillis() < (Long)HttpManagementUtil.getSessionAttribute(ATTR_EXPIRY, session, request)) {
                saslNegotiator = (SaslNegotiator)HttpManagementUtil.getSessionAttribute(ATTR_SASL_NEGOTIATOR, session, request);
            }
            if (saslNegotiator != null) {
                this.evaluateSaslResponse(request, response, session, saslResponse, saslNegotiator, subjectCreator);
            } else {
                this.cleanup(request, session);
                response.setStatus(417);
            }
        }
        catch (SessionInvalidatedException e) {
            response.setStatus(412);
        }
        finally {
            if (response.getStatus() != 200) {
                HttpManagementUtil.invalidateSession(session);
            }
        }
    }

    private void cleanup(HttpServletRequest request, HttpSession session) {
        SaslNegotiator negotiator = (SaslNegotiator)HttpManagementUtil.getSessionAttribute(ATTR_SASL_NEGOTIATOR, session, request);
        if (negotiator != null) {
            negotiator.dispose();
        }
        HttpManagementUtil.removeAttribute(ATTR_ID, session, request);
        HttpManagementUtil.removeAttribute(ATTR_SASL_NEGOTIATOR, session, request);
        HttpManagementUtil.removeAttribute(ATTR_EXPIRY, session, request);
    }

    private void checkSaslAuthEnabled(HttpServletRequest request) {
        boolean saslAuthEnabled = false;
        HttpManagementConfiguration management = this.getManagementConfiguration();
        saslAuthEnabled = request.isSecure() ? management.isHttpsSaslAuthenticationEnabled() : management.isHttpSaslAuthenticationEnabled();
        if (!saslAuthEnabled) {
            throw new ConnectionScopedRuntimeException("Sasl authentication disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateSaslResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, String saslResponse, SaslNegotiator saslNegotiator, SubjectCreator subjectCreator) throws IOException {
        byte[] saslResponseBytes = saslResponse == null ? new byte[]{} : Strings.decodeBase64((String)saslResponse);
        SubjectAuthenticationResult authenticationResult = subjectCreator.authenticate(saslNegotiator, saslResponseBytes);
        byte[] challenge = authenticationResult.getChallenge();
        LinkedHashMap<String, String> outputObject = new LinkedHashMap<String, String>();
        int responseStatus = 500;
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject original = authenticationResult.getSubject();
            Broker<?> broker = this.getBroker();
            try {
                HttpManagementUtil.createServletConnectionSubjectAssertManagementAccessAndSave(broker, request, original);
                if (challenge != null && challenge.length != 0) {
                    outputObject.put("additionalData", Base64.getEncoder().encodeToString(challenge));
                }
                responseStatus = 200;
            }
            catch (SecurityException e) {
                responseStatus = 403;
            }
            finally {
                this.cleanup(request, session);
            }
        } else if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.CONTINUE) {
            Random rand = this.getRandom(request);
            String id = String.valueOf(rand.nextLong());
            HttpManagementUtil.setSessionAttribute(ATTR_ID, id, session, request);
            HttpManagementUtil.setSessionAttribute(ATTR_SASL_NEGOTIATOR, saslNegotiator, session, request);
            long saslExchangeExpiry = this.getManagementConfiguration().getSaslExchangeExpiry();
            HttpManagementUtil.setSessionAttribute(ATTR_EXPIRY, System.currentTimeMillis() + saslExchangeExpiry, session, request);
            outputObject.put("id", id);
            outputObject.put("challenge", Base64.getEncoder().encodeToString(challenge));
            responseStatus = 200;
        } else {
            responseStatus = 401;
            this.cleanup(request, session);
        }
        this.sendJsonResponse(outputObject, request, response, responseStatus, false);
    }

    private SubjectCreator getSubjectCreator(HttpServletRequest request) {
        HttpPort<?> port = HttpManagementUtil.getPort(request);
        return port.getSubjectCreator(request.isSecure(), request.getServerName());
    }

    private AuthenticationProvider<?> getAuthenticationProvider(HttpServletRequest request) {
        return HttpManagementUtil.getManagementConfiguration(this.getServletContext()).getAuthenticationProvider(request);
    }
}

