/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.util.Collection;
import java.util.Iterator;

public abstract class StoredContainer
implements Cloneable {
    DataView view;

    StoredContainer(DataView view) {
        this.view = view;
    }

    public final boolean isWriteAllowed() {
        return this.view.writeAllowed;
    }

    public final CursorConfig getCursorConfig() {
        return DbCompat.cloneCursorConfig(this.view.cursorConfig);
    }

    public final boolean isTransactional() {
        return this.view.transactional;
    }

    final StoredContainer configuredClone(CursorConfig config) {
        try {
            StoredContainer cont = (StoredContainer)this.clone();
            cont.view = cont.view.configuredView(config);
            cont.initAfterClone();
            return cont;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void initAfterClone() {
    }

    public final boolean areDuplicatesAllowed() {
        return this.view.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.view.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.view.keysRenumbered;
    }

    public final boolean isOrdered() {
        return this.view.ordered;
    }

    public final boolean areKeyRangesAllowed() {
        return this.view.keyRangesAllowed;
    }

    public final boolean isSecondary() {
        return this.view.isSecondary();
    }

    public abstract int size();

    public boolean isEmpty() {
        try {
            return this.view.isEmpty();
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public void clear() {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.clear();
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    Object getValue(Object key) {
        DataCursor cursor;
        block5: {
            cursor = null;
            cursor = new DataCursor(this.view, false);
            if (OperationStatus.SUCCESS != cursor.getSearchKey(key, null, false)) break block5;
            Object object = cursor.getCurrentValue();
            this.closeCursor(cursor);
            return object;
        }
        try {
            Object var3_4 = null;
            this.closeCursor(cursor);
            return var3_4;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    Object putKeyValue(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            Object[] oldValue = new Object[1];
            cursor.put(key, value, oldValue, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return oldValue[0];
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    final boolean removeKey(Object key, Object[] oldVal) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            boolean found = false;
            OperationStatus status = cursor.getSearchKey(key, null, true);
            while (status == OperationStatus.SUCCESS) {
                cursor.delete();
                found = true;
                if (oldVal != null && oldVal[0] == null) {
                    oldVal[0] = cursor.getCurrentValue();
                }
                status = this.areDuplicatesAllowed() ? cursor.getNextDup(true) : OperationStatus.NOTFOUND;
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return found;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsKey(Object key) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            boolean bl = OperationStatus.SUCCESS == cursor.getSearchKey(key, null, false);
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final boolean removeValue(Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.findValue(value, true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    boolean containsValue(Object value) {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.findValue(value, true);
            boolean bl = status == OperationStatus.SUCCESS;
            this.closeCursor(cursor);
            return bl;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    final Iterator storedOrExternalIterator(Collection coll) {
        if (coll instanceof StoredCollection) {
            return ((StoredCollection)coll).storedIterator();
        }
        return coll.iterator();
    }

    final void closeCursor(DataCursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
    }

    final boolean beginAutoCommit() {
        if (this.view.transactional) {
            CurrentTransaction currentTxn = this.view.getCurrentTxn();
            try {
                if (currentTxn.isAutoCommitAllowed()) {
                    currentTxn.beginTransaction(null);
                    return true;
                }
            }
            catch (DatabaseException e) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(e);
            }
        }
        return false;
    }

    final void commitAutoCommit(boolean doAutoCommit) throws DatabaseException {
        if (doAutoCommit) {
            this.view.getCurrentTxn().commitTransaction();
        }
    }

    final RuntimeException handleException(Exception e, boolean doAutoCommit) {
        if (doAutoCommit) {
            try {
                this.view.getCurrentTxn().abortTransaction();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return StoredContainer.convertException(e);
    }

    static RuntimeException convertException(Exception e) {
        return RuntimeExceptionWrapper.wrapIfNeeded(e);
    }
}

