/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.rep.AppStateMonitor;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ReplicatedEnvironment
extends Environment {
    private volatile RepImpl repEnvironmentImpl = (RepImpl)DbInternal.getNonNullEnvImpl(this);
    private final NameIdPair nameIdPair = this.repEnvironmentImpl.getNameIdPair();
    private ReplicationConfig handleRepConfig;

    public ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig, ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy) throws EnvironmentNotFoundException, EnvironmentLockedException, InsufficientLogException, ReplicaConsistencyException, IllegalArgumentException {
        this(envHome, repConfig, envConfig, consistencyPolicy, initialElectionPolicy, true, null);
    }

    public ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig) throws EnvironmentNotFoundException, EnvironmentLockedException, ReplicaConsistencyException, InsufficientLogException, RollbackException, IllegalArgumentException {
        this(envHome, repConfig, envConfig, null, QuorumPolicy.SIMPLE_MAJORITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinGroup(RepImpl repImpl, ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy) throws DatabaseException {
        if (this.dontJoinGroup()) {
            return;
        }
        State state = null;
        try {
            state = repImpl.joinGroup(consistencyPolicy, initialElectionPolicy);
        }
        finally {
            if (state == null) {
                repImpl.abnormalClose();
            }
        }
    }

    private boolean dontJoinGroup() {
        return new Boolean(this.getRepConfig().getConfigParam(RepParams.DONT_JOIN_REP_GROUP.getName()));
    }

    protected ReplicatedEnvironment(File envHome, ReplicationConfig repConfig, EnvironmentConfig envConfig, ReplicaConsistencyPolicy consistencyPolicy, QuorumPolicy initialElectionPolicy, boolean joinGroup, RepImpl envImplParam) throws EnvironmentNotFoundException, EnvironmentLockedException, ReplicaConsistencyException, IllegalArgumentException {
        super(envHome, envConfig, repConfig, envImplParam);
        this.repEnvironmentImpl.initializeChannelFactory();
        if (joinGroup) {
            try {
                this.joinGroup(this.repEnvironmentImpl, consistencyPolicy, initialElectionPolicy);
            }
            catch (RollbackException e) {
                DbInternal.clearEnvImpl(this);
                this.repEnvironmentImpl = null;
                this.repEnvironmentImpl = (RepImpl)this.makeEnvironmentImpl(envHome, envConfig, repConfig);
                this.repEnvironmentImpl.initializeChannelFactory();
                this.joinGroup(this.repEnvironmentImpl, consistencyPolicy, initialElectionPolicy);
                this.repEnvironmentImpl.setHardRecoveryInfo(e);
            }
            if (this.repEnvironmentImpl.getRepNode() != null) {
                this.repEnvironmentImpl.getRepNode().getMonitorEventManager().notifyJoinGroup();
            }
        } else if (this.repEnvironmentImpl.getRepNode() != null) {
            throw EnvironmentFailureException.unexpectedState("An earlier handle creation had resulted in the nodejoining the group");
        }
    }

    @Override
    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        ReplicationConfig repConfig = (ReplicationConfig)repConfigProxy;
        ReplicationConfig baseConfig = repConfig == null ? ReplicationConfig.DEFAULT : repConfig;
        ReplicationConfig useConfig = baseConfig.clone();
        if (envConfig.getReadOnly()) {
            boolean arbUse = useConfig.getConfigParam(RepParams.ARBITER_USE.getName()).equals("true");
            boolean subUse = useConfig.getConfigParam(RepParams.SUBSCRIBER_USE.getName()).equals("true");
            boolean networkBackupUse = useConfig.getConfigParam(RepParams.NETWORKBACKUP_USE.getName()).equals("true");
            if (!(arbUse || subUse || networkBackupUse)) {
                throw new IllegalArgumentException("A replicated environment may not be opened read-only");
            }
        }
        DbConfigManager.applyFileConfig(envHome, useConfig.getProps(), true);
        useConfig.propagateRepNetProps();
        this.handleRepConfig = useConfig;
        return this.handleRepConfig;
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public State getState() throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        try {
            return repImpl.getState();
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationGroup getGroup() throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        try {
            return new ReplicationGroup(repImpl.getRepNode().getGroup());
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    @Override
    public synchronized void close() throws DatabaseException {
        try {
            super.close();
        }
        catch (DatabaseException e) {
            e.addErrorMessage("Problem closing handle " + this.nameIdPair);
            throw e;
        }
        catch (Exception e) {
            throw new EnvironmentFailureException(this.repEnvironmentImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION, "Problem closing handle " + this.nameIdPair, e);
        }
        finally {
            this.repEnvironmentImpl = null;
        }
    }

    public void setStateChangeListener(StateChangeListener listener) throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        try {
            repImpl.setChangeListener(listener);
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    public StateChangeListener getStateChangeListener() throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        try {
            return repImpl.getChangeListener();
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    public void setRepMutableConfig(ReplicationMutableConfig mutableConfig) throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
        try {
            repImpl.setRepMutableConfig(mutableConfig);
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationMutableConfig getRepMutableConfig() throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        try {
            ReplicationMutableConfig config = repImpl.cloneRepMutableConfig();
            config.fillInEnvironmentGeneratedProps(repImpl);
            return config;
        }
        catch (Error E) {
            repImpl.invalidate(E);
            throw E;
        }
    }

    public ReplicationConfig getRepConfig() throws DatabaseException {
        this.checkOpen();
        return this.handleRepConfig;
    }

    public ReplicatedEnvironmentStats getRepStats(StatsConfig config) throws DatabaseException {
        RepImpl repImpl = this.checkOpen();
        if (config == null) {
            config = StatsConfig.DEFAULT;
        }
        return repImpl.getStats(config);
    }

    RepImpl getNonNullRepImpl() {
        RepImpl repImpl = this.repEnvironmentImpl;
        if (repImpl == null) {
            throw new IllegalStateException("Environment is closed.");
        }
        return repImpl;
    }

    RepImpl getMaybeNullRepImpl() {
        return this.repEnvironmentImpl;
    }

    private RepImpl checkOpen() {
        DbInternal.checkOpen(this);
        return this.getNonNullRepImpl();
    }

    @Override
    public void printStartupInfo(PrintStream out) {
        super.printStartupInfo(out);
        this.getNonNullRepImpl().getStartupTracker().displayStats(out, StartupTracker.Phase.TOTAL_JOIN_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownGroup(long replicaShutdownTimeout, TimeUnit unit) throws IllegalStateException {
        RepImpl repImpl = this.checkOpen();
        DbEnvPool dbEnvPool = DbEnvPool.getInstance();
        synchronized (dbEnvPool) {
            RepImpl repImpl2 = repImpl;
            synchronized (repImpl2) {
                repImpl.shutdownGroupSetup(unit.toMillis(replicaShutdownTimeout));
                this.close();
            }
        }
    }

    public void registerAppStateMonitor(AppStateMonitor appStateMonitor) throws IllegalStateException {
        RepImpl repImpl = this.checkOpen();
        repImpl.getRepNode().registerAppStateMonitor(appStateMonitor);
    }

    public String transferMaster(Set<String> replicas, int timeout, TimeUnit timeUnit) {
        return this.transferMaster(replicas, timeout, timeUnit, false);
    }

    public String transferMaster(Set<String> replicas, int timeout, TimeUnit timeUnit, boolean force) {
        RepImpl repImpl = this.checkOpen();
        if (timeUnit == null || timeout <= 0) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        return repImpl.transferMaster(replicas, timeUnit.toMillis(timeout), force);
    }

    public static enum State {
        DETACHED,
        UNKNOWN,
        MASTER,
        REPLICA;


        public final boolean isMaster() {
            return this == MASTER;
        }

        public final boolean isReplica() {
            return this == REPLICA;
        }

        public final boolean isDetached() {
            return this == DETACHED;
        }

        public final boolean isUnknown() {
            return this == UNKNOWN;
        }

        public final boolean isActive() {
            return this == MASTER || this == REPLICA;
        }
    }
}

