/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.DirectExchange;
import org.apache.qpid.server.exchange.FilterManagerReplacementRoutingKeyTuple;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectExchangeImpl
extends AbstractExchange<DirectExchangeImpl>
implements DirectExchange<DirectExchangeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectExchangeImpl.class);
    private final ConcurrentMap<String, BindingSet> _bindingsByKey = new ConcurrentHashMap<String, BindingSet>();

    @ManagedObjectFactoryConstructor
    DirectExchangeImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> void doRoute(M payload, String routingKey, InstanceProperties instanceProperties, RoutingResult<M> result) {
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(routingKey == null ? "" : routingKey);
        if (bindings != null) {
            Map<MessageDestination, String> unfilteredDestinations = bindings.getUnfilteredDestinations();
            for (MessageDestination destination : unfilteredDestinations.keySet()) {
                String actualRoutingKey = unfilteredDestinations.get(destination) == null ? routingKey : unfilteredDestinations.get(destination);
                result.add(destination.route(payload, actualRoutingKey, instanceProperties));
            }
            if (bindings.hasFilteredQueues()) {
                Filterable filterable = Filterable.Factory.newInstance(payload, instanceProperties);
                Map<MessageDestination, FilterManagerReplacementRoutingKeyTuple> filteredDestinations = bindings.getFilteredDestinations();
                for (Map.Entry<MessageDestination, FilterManagerReplacementRoutingKeyTuple> entry : filteredDestinations.entrySet()) {
                    String actualRoutingKey;
                    FilterManagerReplacementRoutingKeyTuple tuple = entry.getValue();
                    String string = actualRoutingKey = tuple.getReplacementRoutingKey() == null ? routingKey : tuple.getReplacementRoutingKey();
                    if (!tuple.getFilterManager().allAllow(filterable)) continue;
                    result.add(entry.getKey().route(payload, actualRoutingKey, instanceProperties));
                }
            }
        }
    }

    @Override
    protected void onBindingUpdated(AbstractExchange.BindingIdentifier binding, Map<String, Object> newArguments) throws AMQInvalidArgumentException {
        String bindingKey = binding.getBindingKey();
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(bindingKey);
        this._bindingsByKey.put(bindingKey, bindings.putBinding(binding.getDestination(), newArguments, true));
    }

    @Override
    protected void onBind(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        String bindingKey = binding.getBindingKey();
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(bindingKey);
        if (bindings == null) {
            bindings = new BindingSet();
        }
        this._bindingsByKey.put(bindingKey, bindings.putBinding(binding.getDestination(), arguments, true));
    }

    @Override
    protected void onUnbind(AbstractExchange.BindingIdentifier binding) {
        String bindingKey = binding.getBindingKey();
        BindingSet bindings = (BindingSet)this._bindingsByKey.get(bindingKey);
        BindingSet replacementSet = bindings.removeBinding(binding.getDestination());
        if (replacementSet.isEmpty()) {
            this._bindingsByKey.remove(bindingKey);
        } else {
            this._bindingsByKey.put(bindingKey, replacementSet);
        }
    }

    private static final class BindingSet {
        private final Map<MessageDestination, String> _unfilteredDestinations;
        private final Map<MessageDestination, FilterManagerReplacementRoutingKeyTuple> _filteredDestinations;

        BindingSet() {
            this._unfilteredDestinations = Map.of();
            this._filteredDestinations = Map.of();
        }

        private BindingSet(Map<MessageDestination, String> unfilteredDestinations, Map<MessageDestination, FilterManagerReplacementRoutingKeyTuple> filteredDestinations) {
            this._unfilteredDestinations = unfilteredDestinations;
            this._filteredDestinations = filteredDestinations;
        }

        Map<MessageDestination, String> getUnfilteredDestinations() {
            return this._unfilteredDestinations;
        }

        boolean hasFilteredQueues() {
            return !this._filteredDestinations.isEmpty();
        }

        boolean isEmpty() {
            return this._unfilteredDestinations.isEmpty() && this._filteredDestinations.isEmpty();
        }

        Map<MessageDestination, FilterManagerReplacementRoutingKeyTuple> getFilteredDestinations() {
            return this._filteredDestinations;
        }

        BindingSet putBinding(MessageDestination destination, Map<String, Object> arguments, boolean force) throws AMQInvalidArgumentException {
            Map<MessageDestination, FilterManagerReplacementRoutingKeyTuple> filteredDestinations;
            if (!force && (this._unfilteredDestinations.containsKey(destination) || this._filteredDestinations.containsKey(destination))) {
                return this;
            }
            if (FilterSupport.argumentsContainFilter(arguments)) {
                Map<MessageDestination, String> unfilteredDestinations;
                FilterManager messageFilter = FilterSupport.createMessageFilter(arguments, destination);
                if (this._unfilteredDestinations.containsKey(destination)) {
                    unfilteredDestinations = new HashMap<MessageDestination, String>(this._unfilteredDestinations);
                    unfilteredDestinations.remove(destination);
                } else {
                    unfilteredDestinations = this._unfilteredDestinations;
                }
                HashMap<MessageDestination, FilterManagerReplacementRoutingKeyTuple> filteredDestinations2 = new HashMap<MessageDestination, FilterManagerReplacementRoutingKeyTuple>(this._filteredDestinations);
                String replacementRoutingKey = arguments.get("x-replacement-routing-key") != null ? String.valueOf(arguments.get("x-replacement-routing-key")) : null;
                filteredDestinations2.put(destination, new FilterManagerReplacementRoutingKeyTuple(messageFilter, replacementRoutingKey));
                return new BindingSet(Collections.unmodifiableMap(unfilteredDestinations), Collections.unmodifiableMap(filteredDestinations2));
            }
            if (this._filteredDestinations.containsKey(destination)) {
                filteredDestinations = new HashMap<MessageDestination, FilterManagerReplacementRoutingKeyTuple>(this._filteredDestinations);
                filteredDestinations.remove(destination);
            } else {
                filteredDestinations = this._filteredDestinations;
            }
            HashMap<MessageDestination, String> unfilteredDestinations = new HashMap<MessageDestination, String>(this._unfilteredDestinations);
            Object replacementRoutingKey = arguments == null ? null : arguments.get("x-replacement-routing-key");
            unfilteredDestinations.put(destination, replacementRoutingKey == null ? null : String.valueOf(replacementRoutingKey));
            return new BindingSet(Collections.unmodifiableMap(unfilteredDestinations), Collections.unmodifiableMap(filteredDestinations));
        }

        BindingSet removeBinding(MessageDestination destination) {
            if (this._unfilteredDestinations.containsKey(destination)) {
                HashMap<MessageDestination, String> unfilteredDestinations = new HashMap<MessageDestination, String>(this._unfilteredDestinations);
                unfilteredDestinations.remove(destination);
                return new BindingSet(Collections.unmodifiableMap(unfilteredDestinations), this._filteredDestinations);
            }
            if (this._filteredDestinations.containsKey(destination)) {
                HashMap<MessageDestination, FilterManagerReplacementRoutingKeyTuple> filteredDestinations = new HashMap<MessageDestination, FilterManagerReplacementRoutingKeyTuple>(this._filteredDestinations);
                filteredDestinations.remove(destination);
                return new BindingSet(this._unfilteredDestinations, Collections.unmodifiableMap(filteredDestinations));
            }
            return this;
        }
    }
}

