/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.protocol.body;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class InSyncStateData
extends RemotingSerializable {
    private Map<String, InSyncStateSet> inSyncStateTable = new HashMap<String, InSyncStateSet>();

    public void addInSyncState(String brokerName, InSyncStateSet inSyncState) {
        this.inSyncStateTable.put(brokerName, inSyncState);
    }

    public Map<String, InSyncStateSet> getInSyncStateTable() {
        return this.inSyncStateTable;
    }

    public void setInSyncStateTable(Map<String, InSyncStateSet> inSyncStateTable) {
        this.inSyncStateTable = inSyncStateTable;
    }

    public static class InSyncMember
    extends RemotingSerializable {
        private String address;
        private Long brokerId;

        public InSyncMember(String address, Long brokerId) {
            this.address = address;
            this.brokerId = brokerId;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Long getBrokerId() {
            return this.brokerId;
        }

        public void setBrokerId(Long brokerId) {
            this.brokerId = brokerId;
        }

        public String toString() {
            return "InSyncMember{address='" + this.address + '\'' + ", brokerId=" + this.brokerId + '}';
        }
    }

    public static class InSyncStateSet
    extends RemotingSerializable {
        private String masterAddress;
        private int masterEpoch;
        private int syncStateSetEpoch;
        private List<InSyncMember> inSyncMembers;

        public InSyncStateSet(String masterAddress, int masterEpoch, int syncStateSetEpoch, List<InSyncMember> inSyncMembers) {
            this.masterAddress = masterAddress;
            this.masterEpoch = masterEpoch;
            this.syncStateSetEpoch = syncStateSetEpoch;
            this.inSyncMembers = inSyncMembers;
        }

        public String getMasterAddress() {
            return this.masterAddress;
        }

        public void setMasterAddress(String masterAddress) {
            this.masterAddress = masterAddress;
        }

        public int getMasterEpoch() {
            return this.masterEpoch;
        }

        public void setMasterEpoch(int masterEpoch) {
            this.masterEpoch = masterEpoch;
        }

        public int getSyncStateSetEpoch() {
            return this.syncStateSetEpoch;
        }

        public void setSyncStateSetEpoch(int syncStateSetEpoch) {
            this.syncStateSetEpoch = syncStateSetEpoch;
        }

        public List<InSyncMember> getInSyncMembers() {
            return this.inSyncMembers;
        }

        public void setInSyncMembers(List<InSyncMember> inSyncMembers) {
            this.inSyncMembers = inSyncMembers;
        }
    }
}

