/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigurationManager;

public class ReceiptHandleGroup {
    protected final Map<String, Map<String, HandleData>> receiptHandleMap = new ConcurrentHashMap<String, Map<String, HandleData>>();

    public void put(String msgID, String handle, MessageReceiptHandle value) {
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        Map handleMap = (Map)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)((ConcurrentHashMap)this.receiptHandleMap), (Object)msgID, msgIDKey -> new ConcurrentHashMap());
        handleMap.compute(handle, (handleKey, handleData) -> {
            if (handleData == null || ((HandleData)handleData).needRemove) {
                return new HandleData(value);
            }
            if (!handleData.lock(timeout)) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to put handle failed");
            }
            try {
                if (((HandleData)handleData).needRemove) {
                    HandleData handleData2 = new HandleData(value);
                    return handleData2;
                }
                ((HandleData)handleData).messageReceiptHandle = value;
            }
            finally {
                handleData.unlock();
            }
            return handleData;
        });
    }

    public boolean isEmpty() {
        return this.receiptHandleMap.isEmpty();
    }

    public MessageReceiptHandle remove(String msgID, String handle) {
        Map<String, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return null;
        }
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        AtomicReference res = new AtomicReference();
        handleMap.computeIfPresent(handle, (handleKey, handleData) -> {
            if (!handleData.lock(timeout)) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to remove and get handle failed");
            }
            try {
                if (!((HandleData)handleData).needRemove) {
                    ((HandleData)handleData).needRemove = true;
                    res.set(((HandleData)handleData).messageReceiptHandle);
                }
                HandleData handleData2 = null;
                return handleData2;
            }
            finally {
                handleData.unlock();
            }
        });
        this.removeHandleMapKeyIfNeed(msgID);
        return (MessageReceiptHandle)res.get();
    }

    public void computeIfPresent(String msgID, String handle, Function<MessageReceiptHandle, CompletableFuture<MessageReceiptHandle>> function) {
        Map<String, HandleData> handleMap = this.receiptHandleMap.get(msgID);
        if (handleMap == null) {
            return;
        }
        long timeout = ConfigurationManager.getProxyConfig().getLockTimeoutMsInHandleGroup();
        handleMap.computeIfPresent(handle, (handleKey, handleData) -> {
            if (!handleData.lock(timeout)) {
                throw new ProxyException(ProxyExceptionCode.INTERNAL_SERVER_ERROR, "try to compute failed");
            }
            CompletableFuture future = (CompletableFuture)function.apply(((HandleData)handleData).messageReceiptHandle);
            future.whenComplete((messageReceiptHandle, throwable) -> {
                try {
                    if (throwable != null) {
                        return;
                    }
                    if (messageReceiptHandle == null) {
                        ((HandleData)handleData).needRemove = true;
                    } else {
                        ((HandleData)handleData).messageReceiptHandle = messageReceiptHandle;
                    }
                }
                finally {
                    handleData.unlock();
                }
                if (((HandleData)handleData).needRemove) {
                    handleMap.remove(handleKey, handleData);
                }
                this.removeHandleMapKeyIfNeed(msgID);
            });
            return handleData;
        });
    }

    protected void removeHandleMapKeyIfNeed(String msgID) {
        this.receiptHandleMap.computeIfPresent(msgID, (msgIDKey, handleMap) -> {
            if (handleMap.isEmpty()) {
                return null;
            }
            return handleMap;
        });
    }

    public void scan(DataScanner scanner) {
        this.receiptHandleMap.forEach((msgID, handleMap) -> handleMap.forEach((handleStr, v) -> scanner.onData((String)msgID, (String)handleStr, ((HandleData)v).messageReceiptHandle)));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("receiptHandleMap", this.receiptHandleMap).toString();
    }

    public static interface DataScanner {
        public void onData(String var1, String var2, MessageReceiptHandle var3);
    }

    public static class HandleData {
        private final Semaphore semaphore = new Semaphore(1);
        private volatile boolean needRemove = false;
        private volatile MessageReceiptHandle messageReceiptHandle;

        public HandleData(MessageReceiptHandle messageReceiptHandle) {
            this.messageReceiptHandle = messageReceiptHandle;
        }

        public boolean lock(long timeoutMs) {
            try {
                return this.semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        public void unlock() {
            this.semaphore.release();
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.semaphore, this.needRemove, this.messageReceiptHandle});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("semaphore", (Object)this.semaphore).add("needRemove", this.needRemove).add("messageReceiptHandle", (Object)this.messageReceiptHandle).toString();
        }
    }
}

