/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.common.utils.ServiceProvider;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.grpc.GrpcServer;
import org.apache.rocketmq.proxy.grpc.interceptor.AuthenticationInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.ContextInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.GlobalExceptionInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.HeaderInterceptor;

public class GrpcServerBuilder {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqProxy");
    protected NettyServerBuilder serverBuilder;

    public static GrpcServerBuilder newBuilder(ThreadPoolExecutor executor, int port) {
        return new GrpcServerBuilder(executor, port);
    }

    protected GrpcServerBuilder(ThreadPoolExecutor executor, int port) {
        this.serverBuilder = NettyServerBuilder.forPort((int)port);
        try {
            this.configSslContext(this.serverBuilder);
        }
        catch (Exception e) {
            log.error("grpc tls set failed. msg: {}, e:", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("grpc tls set failed: " + e.getMessage());
        }
        int bossLoopNum = ConfigurationManager.getProxyConfig().getGrpcBossLoopNum();
        int workerLoopNum = ConfigurationManager.getProxyConfig().getGrpcWorkerLoopNum();
        int maxInboundMessageSize = ConfigurationManager.getProxyConfig().getGrpcMaxInboundMessageSize();
        long idleTimeMills = ConfigurationManager.getProxyConfig().getGrpcClientIdleTimeMills();
        if (ConfigurationManager.getProxyConfig().isEnableGrpcEpoll()) {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(workerLoopNum)).channelType(EpollServerSocketChannel.class).executor((Executor)executor);
        } else {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(workerLoopNum)).channelType(NioServerSocketChannel.class).executor((Executor)executor);
        }
        this.serverBuilder.maxInboundMessageSize(maxInboundMessageSize).maxConnectionIdle(idleTimeMills, TimeUnit.MILLISECONDS);
        log.info("grpc server has built. port: {}, tlsKeyPath: {}, tlsCertPath: {}, threadPool: {}, queueCapacity: {}, boosLoop: {}, workerLoop: {}, maxInboundMessageSize: {}", new Object[]{port, bossLoopNum, workerLoopNum, maxInboundMessageSize});
    }

    public GrpcServerBuilder addService(BindableService service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder addService(ServerServiceDefinition service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder appendInterceptor(ServerInterceptor interceptor) {
        this.serverBuilder.intercept(interceptor);
        return this;
    }

    public GrpcServer build() {
        return new GrpcServer(this.serverBuilder.build());
    }

    protected void configSslContext(NettyServerBuilder serverBuilder) throws SSLException, CertificateException {
        if (null == serverBuilder) {
            return;
        }
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        boolean tlsTestModeEnable = proxyConfig.isGrpcTlsTestModeEnable();
        if (tlsTestModeEnable) {
            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
            serverBuilder.sslContext(GrpcSslContexts.forServer((File)selfSignedCertificate.certificate(), (File)selfSignedCertificate.privateKey()).trustManager(InsecureTrustManagerFactory.INSTANCE).clientAuth(ClientAuth.NONE).build());
            return;
        }
        String tlsKeyPath = ConfigurationManager.getProxyConfig().getGrpcTlsKeyPath();
        String tlsCertPath = ConfigurationManager.getProxyConfig().getGrpcTlsCertPath();
        try (InputStream serverKeyInputStream = Files.newInputStream(Paths.get(tlsKeyPath, new String[0]), new OpenOption[0]);
             InputStream serverCertificateStream = Files.newInputStream(Paths.get(tlsCertPath, new String[0]), new OpenOption[0]);){
            serverBuilder.sslContext(GrpcSslContexts.forServer((InputStream)serverCertificateStream, (InputStream)serverKeyInputStream).trustManager(InsecureTrustManagerFactory.INSTANCE).clientAuth(ClientAuth.NONE).build());
            log.info("TLS configured OK");
        }
        catch (IOException e) {
            log.error("Failed to load Server key/certificate", (Throwable)e);
        }
    }

    public GrpcServerBuilder configInterceptor() {
        List accessValidators = ServiceProvider.load((String)"META-INF/service/org.apache.rocketmq.acl.AccessValidator", AccessValidator.class);
        if (!accessValidators.isEmpty()) {
            this.serverBuilder.intercept((ServerInterceptor)new AuthenticationInterceptor(accessValidators));
        }
        ((NettyServerBuilder)((NettyServerBuilder)this.serverBuilder.intercept((ServerInterceptor)new GlobalExceptionInterceptor())).intercept((ServerInterceptor)new ContextInterceptor())).intercept((ServerInterceptor)new HeaderInterceptor());
        return this;
    }
}

