/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.common.utils.FutureUtils;
import org.apache.rocketmq.proxy.processor.AbstractProcessor;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.processor.PopMessageResultFilter;
import org.apache.rocketmq.proxy.processor.QueueSelector;
import org.apache.rocketmq.proxy.service.ServiceManager;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class ConsumerProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ExecutorService executor;

    public ConsumerProcessor(MessagingProcessor messagingProcessor, ServiceManager serviceManager, ExecutorService executor) {
        super(messagingProcessor, serviceManager);
        this.executor = executor;
    }

    public CompletableFuture<PopResult> popMessage(ProxyContext ctx, QueueSelector queueSelector, String consumerGroup, String topic, int maxMsgNums, long invisibleTime, long pollTime, int initMode, SubscriptionData subscriptionData, boolean fifo, PopMessageResultFilter popMessageResultFilter, long timeoutMillis) {
        CompletableFuture<PopResult> future = new CompletableFuture<PopResult>();
        try {
            AddressableMessageQueue messageQueue = queueSelector.select(ctx, this.serviceManager.getTopicRouteService().getCurrentMessageQueueView(topic));
            if (messageQueue == null) {
                throw new ProxyException(ProxyExceptionCode.FORBIDDEN, "no readable queue");
            }
            return this.popMessage(ctx, messageQueue, consumerGroup, topic, maxMsgNums, invisibleTime, pollTime, initMode, subscriptionData, fifo, popMessageResultFilter, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            return future;
        }
    }

    public CompletableFuture<PopResult> popMessage(ProxyContext ctx, AddressableMessageQueue messageQueue, String consumerGroup, String topic, int maxMsgNums, long invisibleTime, long pollTime, int initMode, SubscriptionData subscriptionData, boolean fifo, PopMessageResultFilter popMessageResultFilter, long timeoutMillis) {
        CompletionStage future = new CompletableFuture();
        try {
            if (maxMsgNums > 32) {
                log.warn("change maxNums from {} to {} for pop request, with info: topic:{}, group:{}", new Object[]{maxMsgNums, 32, topic, consumerGroup});
                maxMsgNums = 32;
            }
            PopMessageRequestHeader requestHeader = new PopMessageRequestHeader();
            requestHeader.setConsumerGroup(consumerGroup);
            requestHeader.setTopic(topic);
            requestHeader.setQueueId(Integer.valueOf(messageQueue.getQueueId()));
            requestHeader.setMaxMsgNums(maxMsgNums);
            requestHeader.setInvisibleTime(invisibleTime);
            requestHeader.setPollTime(pollTime);
            requestHeader.setInitMode(initMode);
            requestHeader.setExpType(subscriptionData.getExpressionType());
            requestHeader.setExp(subscriptionData.getSubString());
            requestHeader.setOrder(Boolean.valueOf(fifo));
            future = this.serviceManager.getMessageService().popMessage(ctx, messageQueue, requestHeader, timeoutMillis).thenApplyAsync(popResult -> {
                if (PopStatus.FOUND.equals((Object)popResult.getPopStatus()) && popResult.getMsgFoundList() != null && !popResult.getMsgFoundList().isEmpty() && popMessageResultFilter != null) {
                    ArrayList<MessageExt> messageExtList = new ArrayList<MessageExt>();
                    for (MessageExt messageExt : popResult.getMsgFoundList()) {
                        try {
                            String handleString = this.createHandle(messageExt.getProperty("POP_CK"), messageExt.getCommitLogOffset());
                            if (handleString == null) {
                                log.error("[BUG] pop message from broker but handle is empty. requestHeader:{}, msg:{}", (Object)requestHeader, (Object)messageExt);
                                messageExtList.add(messageExt);
                                continue;
                            }
                            MessageAccessor.putProperty((Message)messageExt, (String)"POP_CK", (String)handleString);
                            PopMessageResultFilter.FilterResult filterResult = popMessageResultFilter.filterMessage(ctx, consumerGroup, subscriptionData, messageExt);
                            switch (filterResult) {
                                case NO_MATCH: {
                                    this.messagingProcessor.ackMessage(ctx, ReceiptHandle.decode((String)handleString), messageExt.getMsgId(), consumerGroup, topic, MessagingProcessor.DEFAULT_TIMEOUT_MILLS);
                                    break;
                                }
                                case TO_DLQ: {
                                    this.messagingProcessor.forwardMessageToDeadLetterQueue(ctx, ReceiptHandle.decode((String)handleString), messageExt.getMsgId(), consumerGroup, topic, MessagingProcessor.DEFAULT_TIMEOUT_MILLS);
                                    break;
                                }
                                default: {
                                    messageExtList.add(messageExt);
                                    break;
                                }
                            }
                        }
                        catch (Throwable t) {
                            log.error("process filterMessage failed. requestHeader:{}, msg:{}", new Object[]{requestHeader, messageExt, t});
                            messageExtList.add(messageExt);
                        }
                    }
                    popResult.setMsgFoundList(messageExtList);
                }
                return popResult;
            }, (Executor)this.executor);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<AckResult> ackMessage(ProxyContext ctx, ReceiptHandle handle, String messageId, String consumerGroup, String topic, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            this.validateReceiptHandle(handle);
            AckMessageRequestHeader ackMessageRequestHeader = new AckMessageRequestHeader();
            ackMessageRequestHeader.setConsumerGroup(consumerGroup);
            ackMessageRequestHeader.setTopic(handle.getRealTopic(topic, consumerGroup));
            ackMessageRequestHeader.setQueueId(Integer.valueOf(handle.getQueueId()));
            ackMessageRequestHeader.setExtraInfo(handle.getReceiptHandle());
            ackMessageRequestHeader.setOffset(Long.valueOf(handle.getOffset()));
            future = this.serviceManager.getMessageService().ackMessage(ctx, handle, messageId, ackMessageRequestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<AckResult> changeInvisibleTime(ProxyContext ctx, ReceiptHandle handle, String messageId, String groupName, String topicName, long invisibleTime, long timeoutMillis) {
        CompletionStage future = new CompletableFuture();
        try {
            this.validateReceiptHandle(handle);
            ChangeInvisibleTimeRequestHeader changeInvisibleTimeRequestHeader = new ChangeInvisibleTimeRequestHeader();
            changeInvisibleTimeRequestHeader.setConsumerGroup(groupName);
            changeInvisibleTimeRequestHeader.setTopic(handle.getRealTopic(topicName, groupName));
            changeInvisibleTimeRequestHeader.setQueueId(Integer.valueOf(handle.getQueueId()));
            changeInvisibleTimeRequestHeader.setExtraInfo(handle.getReceiptHandle());
            changeInvisibleTimeRequestHeader.setOffset(Long.valueOf(handle.getOffset()));
            changeInvisibleTimeRequestHeader.setInvisibleTime(Long.valueOf(invisibleTime));
            long commitLogOffset = handle.getCommitLogOffset();
            future = this.serviceManager.getMessageService().changeInvisibleTime(ctx, handle, messageId, changeInvisibleTimeRequestHeader, timeoutMillis).thenApplyAsync(ackResult -> {
                if (StringUtils.isNotBlank((CharSequence)ackResult.getExtraInfo())) {
                    AckResult result = new AckResult();
                    result.setStatus(ackResult.getStatus());
                    result.setPopTime(result.getPopTime());
                    result.setExtraInfo(this.createHandle(ackResult.getExtraInfo(), commitLogOffset));
                    return result;
                }
                return ackResult;
            }, (Executor)this.executor);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    protected String createHandle(String handleString, long commitLogOffset) {
        if (handleString == null) {
            return null;
        }
        return handleString + " " + commitLogOffset;
    }

    public CompletableFuture<PullResult> pullMessage(ProxyContext ctx, MessageQueue messageQueue, String consumerGroup, long queueOffset, int maxMsgNums, int sysFlag, long commitOffset, long suspendTimeoutMillis, SubscriptionData subscriptionData, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            AddressableMessageQueue addressableMessageQueue = this.serviceManager.getTopicRouteService().buildAddressableMessageQueue(messageQueue);
            PullMessageRequestHeader requestHeader = new PullMessageRequestHeader();
            requestHeader.setConsumerGroup(consumerGroup);
            requestHeader.setTopic(addressableMessageQueue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(addressableMessageQueue.getQueueId()));
            requestHeader.setQueueOffset(Long.valueOf(queueOffset));
            requestHeader.setMaxMsgNums(Integer.valueOf(maxMsgNums));
            requestHeader.setSysFlag(Integer.valueOf(sysFlag));
            requestHeader.setCommitOffset(Long.valueOf(commitOffset));
            requestHeader.setSuspendTimeoutMillis(Long.valueOf(suspendTimeoutMillis));
            requestHeader.setSubscription(subscriptionData.getSubString());
            requestHeader.setExpressionType(subscriptionData.getExpressionType());
            future = this.serviceManager.getMessageService().pullMessage(ctx, addressableMessageQueue, requestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Void> updateConsumerOffset(ProxyContext ctx, MessageQueue messageQueue, String consumerGroup, long commitOffset, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            AddressableMessageQueue addressableMessageQueue = this.serviceManager.getTopicRouteService().buildAddressableMessageQueue(messageQueue);
            UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
            requestHeader.setConsumerGroup(consumerGroup);
            requestHeader.setTopic(addressableMessageQueue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(addressableMessageQueue.getQueueId()));
            requestHeader.setCommitOffset(Long.valueOf(commitOffset));
            future = this.serviceManager.getMessageService().updateConsumerOffset(ctx, addressableMessageQueue, requestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Long> queryConsumerOffset(ProxyContext ctx, MessageQueue messageQueue, String consumerGroup, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            AddressableMessageQueue addressableMessageQueue = this.serviceManager.getTopicRouteService().buildAddressableMessageQueue(messageQueue);
            QueryConsumerOffsetRequestHeader requestHeader = new QueryConsumerOffsetRequestHeader();
            requestHeader.setConsumerGroup(consumerGroup);
            requestHeader.setTopic(addressableMessageQueue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(addressableMessageQueue.getQueueId()));
            future = this.serviceManager.getMessageService().queryConsumerOffset(ctx, addressableMessageQueue, requestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Set<MessageQueue>> lockBatchMQ(ProxyContext ctx, Set<MessageQueue> mqSet, String consumerGroup, String clientId, long timeoutMillis) {
        CompletableFuture future = new CompletableFuture();
        CopyOnWriteArraySet successSet = new CopyOnWriteArraySet();
        Set<AddressableMessageQueue> addressableMessageQueueSet = this.buildAddressableSet(mqSet);
        HashMap<String, List<AddressableMessageQueue>> messageQueueSetMap = this.buildAddressableMapByBrokerName(addressableMessageQueueSet);
        ArrayList futureList = new ArrayList();
        messageQueueSetMap.forEach((k, v) -> {
            LockBatchRequestBody requestBody = new LockBatchRequestBody();
            requestBody.setConsumerGroup(consumerGroup);
            requestBody.setClientId(clientId);
            requestBody.setMqSet(v.stream().map(AddressableMessageQueue::getMessageQueue).collect(Collectors.toSet()));
            CompletionStage future0 = this.serviceManager.getMessageService().lockBatchMQ(ctx, (AddressableMessageQueue)v.get(0), requestBody, timeoutMillis).thenAccept(successSet::addAll);
            futureList.add(FutureUtils.addExecutor(future0, this.executor));
        });
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> {
            if (t != null) {
                log.error("LockBatchMQ failed", t);
            }
            future.complete(successSet);
        });
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Void> unlockBatchMQ(ProxyContext ctx, Set<MessageQueue> mqSet, String consumerGroup, String clientId, long timeoutMillis) {
        CompletableFuture future = new CompletableFuture();
        Set<AddressableMessageQueue> addressableMessageQueueSet = this.buildAddressableSet(mqSet);
        HashMap<String, List<AddressableMessageQueue>> messageQueueSetMap = this.buildAddressableMapByBrokerName(addressableMessageQueueSet);
        ArrayList futureList = new ArrayList();
        messageQueueSetMap.forEach((k, v) -> {
            UnlockBatchRequestBody requestBody = new UnlockBatchRequestBody();
            requestBody.setConsumerGroup(consumerGroup);
            requestBody.setClientId(clientId);
            requestBody.setMqSet(v.stream().map(AddressableMessageQueue::getMessageQueue).collect(Collectors.toSet()));
            CompletableFuture<Void> future0 = this.serviceManager.getMessageService().unlockBatchMQ(ctx, (AddressableMessageQueue)v.get(0), requestBody, timeoutMillis);
            futureList.add(FutureUtils.addExecutor(future0, this.executor));
        });
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((v, t) -> {
            if (t != null) {
                log.error("UnlockBatchMQ failed", t);
            }
            future.complete(null);
        });
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Long> getMaxOffset(ProxyContext ctx, MessageQueue messageQueue, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            AddressableMessageQueue addressableMessageQueue = this.serviceManager.getTopicRouteService().buildAddressableMessageQueue(messageQueue);
            GetMaxOffsetRequestHeader requestHeader = new GetMaxOffsetRequestHeader();
            requestHeader.setTopic(addressableMessageQueue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(addressableMessageQueue.getQueueId()));
            future = this.serviceManager.getMessageService().getMaxOffset(ctx, addressableMessageQueue, requestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    public CompletableFuture<Long> getMinOffset(ProxyContext ctx, MessageQueue messageQueue, long timeoutMillis) {
        CompletableFuture<Object> future = new CompletableFuture();
        try {
            AddressableMessageQueue addressableMessageQueue = this.serviceManager.getTopicRouteService().buildAddressableMessageQueue(messageQueue);
            GetMinOffsetRequestHeader requestHeader = new GetMinOffsetRequestHeader();
            requestHeader.setTopic(addressableMessageQueue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(addressableMessageQueue.getQueueId()));
            future = this.serviceManager.getMessageService().getMinOffset(ctx, addressableMessageQueue, requestHeader, timeoutMillis);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return FutureUtils.addExecutor(future, this.executor);
    }

    protected Set<AddressableMessageQueue> buildAddressableSet(Set<MessageQueue> mqSet) {
        return mqSet.stream().map(mq -> {
            try {
                return this.serviceManager.getTopicRouteService().buildAddressableMessageQueue((MessageQueue)mq);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toSet());
    }

    protected HashMap<String, List<AddressableMessageQueue>> buildAddressableMapByBrokerName(Set<AddressableMessageQueue> mqSet) {
        HashMap<String, List<AddressableMessageQueue>> result = new HashMap<String, List<AddressableMessageQueue>>();
        for (AddressableMessageQueue mq : mqSet) {
            List mqs = result.computeIfAbsent(mq.getBrokerName(), k -> new ArrayList());
            mqs.add(mq);
        }
        return result;
    }
}

