/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.common.AttributesBuilder;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.rocketmq.common.AbortProcessException;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyLogger;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public abstract class NettyRemotingAbstract {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap<Integer, ResponseFuture>(256);
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyEventExecutor nettyEventExecutor = new NettyEventExecutor();
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessorPair;
    protected volatile SslContext sslContext;
    protected List<RPCHook> rpcHooks = new ArrayList<RPCHook>();

    public NettyRemotingAbstract(int permitsOneway, int permitsAsync) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
    }

    public abstract ChannelEventListener getChannelEventListener();

    public void putNettyEvent(NettyEvent event) {
        this.nettyEventExecutor.putNettyEvent(event);
    }

    public void processMessageReceived(ChannelHandlerContext ctx, RemotingCommand msg) {
        if (msg != null) {
            switch (msg.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(ctx, msg);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(ctx, msg);
                    break;
                }
            }
        }
    }

    protected void doBeforeRpcHooks(String addr, RemotingCommand request) {
        if (this.rpcHooks.size() > 0) {
            for (RPCHook rpcHook : this.rpcHooks) {
                rpcHook.doBeforeRequest(addr, request);
            }
        }
    }

    public void doAfterRpcHooks(String addr, RemotingCommand request, RemotingCommand response) {
        if (this.rpcHooks.size() > 0) {
            for (RPCHook rpcHook : this.rpcHooks) {
                rpcHook.doAfterResponse(addr, request, response);
            }
        }
    }

    public static void writeResponse(Channel channel, RemotingCommand request, @Nullable RemotingCommand response) {
        NettyRemotingAbstract.writeResponse(channel, request, response, null);
    }

    public static void writeResponse(Channel channel, RemotingCommand request, @Nullable RemotingCommand response, Consumer<Future<?>> callback) {
        if (response == null) {
            return;
        }
        AttributesBuilder attributesBuilder = RemotingMetricsManager.newAttributesBuilder().put("is_long_polling", request.isSuspended()).put("request_code", RemotingMetricsManager.getRequestCodeDesc(request.getCode())).put("response_code", RemotingMetricsManager.getResponseCodeDesc(response.getCode()));
        if (request.isOnewayRPC()) {
            attributesBuilder.put("result", "oneway");
            RemotingMetricsManager.rpcLatency.record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributesBuilder.build());
            return;
        }
        response.setOpaque(request.getOpaque());
        response.markResponseType();
        try {
            channel.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    log.debug("Response[request code: {}, response code: {}, opaque: {}] is written to channel{}", new Object[]{request.getCode(), response.getCode(), response.getOpaque(), channel});
                } else {
                    log.error("Failed to write response[request code: {}, response code: {}, opaque: {}] to channel{}", new Object[]{request.getCode(), response.getCode(), response.getOpaque(), channel, future.cause()});
                }
                attributesBuilder.put("result", RemotingMetricsManager.getWriteAndFlushResult(future));
                RemotingMetricsManager.rpcLatency.record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributesBuilder.build());
                if (callback != null) {
                    callback.accept(future);
                }
            }));
        }
        catch (Throwable e) {
            log.error("process request over, but response failed", e);
            log.error(request.toString());
            log.error(response.toString());
            attributesBuilder.put("result", "write_channel_failed");
            RemotingMetricsManager.rpcLatency.record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributesBuilder.build());
        }
    }

    public void processRequestCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        Pair<NettyRequestProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        Pair<NettyRequestProcessor, ExecutorService> pair = null == matched ? this.defaultRequestProcessorPair : matched;
        int opaque = cmd.getOpaque();
        if (pair == null) {
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(3, error);
            response.setOpaque(opaque);
            NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
            log.error(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + error);
            return;
        }
        Runnable run = this.buildProcessRequestHandler(ctx, cmd, pair, opaque);
        if (((NettyRequestProcessor)pair.getObject1()).rejectRequest()) {
            RemotingCommand response = RemotingCommand.createResponseCommand(2, "[REJECTREQUEST]system busy, start flow control for a while");
            response.setOpaque(opaque);
            NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
            return;
        }
        try {
            RequestTask requestTask = new RequestTask(run, ctx.channel(), cmd);
            ((ExecutorService)pair.getObject2()).submit(requestTask);
        }
        catch (RejectedExecutionException e) {
            if (System.currentTimeMillis() % 10000L == 0L) {
                log.warn(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + ((ExecutorService)pair.getObject2()).toString() + " request code: " + cmd.getCode());
            }
            RemotingCommand response = RemotingCommand.createResponseCommand(2, "[OVERLOAD]system busy, start flow control for a while");
            response.setOpaque(opaque);
            NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
        }
        catch (Throwable e) {
            AttributesBuilder attributesBuilder = RemotingMetricsManager.newAttributesBuilder().put("request_code", RemotingMetricsManager.getRequestCodeDesc(cmd.getCode())).put("result", "process_request_failed");
            RemotingMetricsManager.rpcLatency.record(cmd.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributesBuilder.build());
        }
    }

    private Runnable buildProcessRequestHandler(ChannelHandlerContext ctx, RemotingCommand cmd, Pair<NettyRequestProcessor, ExecutorService> pair, int opaque) {
        return () -> {
            block10: {
                Exception exception = null;
                try {
                    String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                    try {
                        this.doBeforeRpcHooks(remoteAddr, cmd);
                    }
                    catch (AbortProcessException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    RemotingCommand response = exception == null ? ((NettyRequestProcessor)pair.getObject1()).processRequest(ctx, cmd) : RemotingCommand.createResponseCommand(1, null);
                    try {
                        this.doAfterRpcHooks(remoteAddr, cmd, response);
                    }
                    catch (AbortProcessException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    if (exception != null) {
                        throw exception;
                    }
                    NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
                }
                catch (AbortProcessException e) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(e.getResponseCode(), e.getErrorMessage());
                    response.setOpaque(opaque);
                    NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
                }
                catch (Throwable e) {
                    log.error("process request exception", e);
                    log.error(cmd.toString());
                    if (cmd.isOnewayRPC()) break block10;
                    RemotingCommand response = RemotingCommand.createResponseCommand(1, UtilAll.exceptionSimpleDesc((Throwable)e));
                    response.setOpaque(opaque);
                    NettyRemotingAbstract.writeResponse(ctx.channel(), cmd, response);
                }
            }
        };
    }

    public void processResponseCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        int opaque = cmd.getOpaque();
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(opaque);
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            this.responseTable.remove(opaque);
            if (responseFuture.getInvokeCallback() != null) {
                this.executeInvokeCallback(responseFuture);
            } else {
                responseFuture.putResponse(cmd);
                responseFuture.release();
            }
        } else {
            log.warn("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            log.warn(cmd.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInvokeCallback(ResponseFuture responseFuture) {
        boolean runInThisThread = false;
        ExecutorService executor = this.getCallbackExecutor();
        if (executor != null && !executor.isShutdown()) {
            try {
                executor.submit(() -> {
                    try {
                        responseFuture.executeInvokeCallback();
                    }
                    catch (Throwable e) {
                        log.warn("execute callback in executor exception, and callback throw", e);
                    }
                    finally {
                        responseFuture.release();
                    }
                });
            }
            catch (Exception e) {
                runInThisThread = true;
                log.warn("execute callback in executor exception, maybe executor busy", (Throwable)e);
            }
        } else {
            runInThisThread = true;
        }
        if (runInThisThread) {
            try {
                responseFuture.executeInvokeCallback();
            }
            catch (Throwable e) {
                log.warn("executeInvokeCallback Exception", e);
            }
            finally {
                responseFuture.release();
            }
        }
    }

    public List<RPCHook> getRPCHook() {
        return this.rpcHooks;
    }

    public void registerRPCHook(RPCHook rpcHook) {
        if (rpcHook != null && !this.rpcHooks.contains(rpcHook)) {
            this.rpcHooks.add(rpcHook);
        }
    }

    public void clearRPCHook() {
        this.rpcHooks.clear();
    }

    public abstract ExecutorService getCallbackExecutor();

    public void scanResponseTable() {
        LinkedList<ResponseFuture> rfList = new LinkedList<ResponseFuture>();
        Iterator it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ResponseFuture rep = (ResponseFuture)next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            rep.release();
            it.remove();
            rfList.add(rep);
            log.warn("remove timeout request, " + rep);
        }
        for (ResponseFuture rf : rfList) {
            try {
                this.executeInvokeCallback(rf);
            }
            catch (Throwable e) {
                log.warn("scanResponseTable, operationComplete Exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        int opaque = request.getOpaque();
        try {
            ResponseFuture responseFuture = new ResponseFuture(channel, opaque, timeoutMillis, null, null);
            this.responseTable.put(opaque, responseFuture);
            SocketAddress addr = channel.remoteAddress();
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                if (f.isSuccess()) {
                    responseFuture.setSendRequestOK(true);
                    return;
                }
                responseFuture.setSendRequestOK(false);
                this.responseTable.remove(opaque);
                responseFuture.setCause(f.cause());
                responseFuture.putResponse(null);
                log.warn("Failed to write a request command to {}, caused by underlying I/O operation failure", (Object)addr);
            }));
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseSocketAddressAddr(addr), timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseSocketAddressAddr(addr), responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            this.responseTable.remove(opaque);
        }
    }

    public void invokeAsyncImpl(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        long beginStartTime = System.currentTimeMillis();
        int opaque = request.getOpaque();
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            long costTime = System.currentTimeMillis() - beginStartTime;
            if (timeoutMillis < costTime) {
                once.release();
                throw new RemotingTimeoutException("invokeAsyncImpl call timeout");
            }
            ResponseFuture responseFuture = new ResponseFuture(channel, opaque, timeoutMillis - costTime, invokeCallback, once);
            this.responseTable.put(opaque, responseFuture);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    this.requestFail(opaque);
                    log.warn("send a request command to channel <{}> failed.", (Object)RemotingHelper.parseChannelRemoteAddr(channel));
                }));
            }
            catch (Exception e) {
                responseFuture.release();
                log.warn("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception", (Throwable)e);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFail(int opaque) {
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.remove(opaque);
        if (responseFuture != null) {
            responseFuture.setSendRequestOK(false);
            responseFuture.putResponse(null);
            try {
                this.executeInvokeCallback(responseFuture);
            }
            catch (Throwable e) {
                log.warn("execute callback in requestFail, and callback throw", e);
            }
            finally {
                responseFuture.release();
            }
        }
    }

    protected void failFast(Channel channel) {
        for (Map.Entry entry : this.responseTable.entrySet()) {
            Integer opaque;
            if (((ResponseFuture)entry.getValue()).getChannel() != channel || (opaque = (Integer)entry.getKey()) == null) continue;
            this.requestFail(opaque);
        }
    }

    public void invokeOnewayImpl(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        request.markOnewayRPC();
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
                    once.release();
                    if (!f.isSuccess()) {
                        log.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                    }
                }));
            }
            catch (Exception e) {
                once.release();
                log.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String info = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreOnewayValue: %d", timeoutMillis, this.semaphoreOneway.getQueueLength(), this.semaphoreOneway.availablePermits());
            log.warn(info);
            throw new RemotingTimeoutException(info);
        }
    }

    static {
        NettyLogger.initNettyLogger();
    }

    class NettyEventExecutor
    extends ServiceThread {
        private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();

        NettyEventExecutor() {
        }

        public void putNettyEvent(NettyEvent event) {
            int maxSize;
            int currentSize = this.eventQueue.size();
            if (currentSize <= (maxSize = 10000)) {
                this.eventQueue.add(event);
            } else {
                log.warn("event queue size [{}] over the limit [{}], so drop this event {}", new Object[]{currentSize, maxSize, event.toString()});
            }
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            ChannelEventListener listener = NettyRemotingAbstract.this.getChannelEventListener();
            while (!this.isStopped()) {
                try {
                    NettyEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null || listener == null) continue;
                    switch (event.getType()) {
                        case IDLE: {
                            listener.onChannelIdle(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            log.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            return NettyEventExecutor.class.getSimpleName();
        }
    }
}

