/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.netty.TlsHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.proxy.SocksProxyConfig;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final Map<String, SocksProxyConfig> proxyMap = new HashMap<String, SocksProxyConfig>();
    private final ConcurrentHashMap<String, Bootstrap> bootstrapMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap<String, ChannelWrapper>();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final ConcurrentMap<String, Boolean> availableNamesrvAddrMap = new ConcurrentHashMap<String, Boolean>();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyRemotingClient.initValueIndex());
    private final Lock namesrvChannelLock = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ExecutorService scanExecutor;
    private ExecutorService callbackExecutor;
    private final ChannelEventListener channelEventListener;
    private EventExecutorGroup defaultEventExecutorGroup;

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        this(nettyClientConfig, channelEventListener, null, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        this.loadSocksProxyJson();
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.scanExecutor = new ThreadPoolExecutor(4, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(32), new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientScan_thread_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = eventLoopGroup != null ? eventLoopGroup : new NioEventLoopGroup(1, new ThreadFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
        this.defaultEventExecutorGroup = eventExecutorGroup;
        if (nettyClientConfig.isUseTLS()) {
            try {
                this.sslContext = TlsHelper.buildSslContext(true);
                LOGGER.info("SSL enabled for client");
            }
            catch (IOException e) {
                LOGGER.error("Failed to create SSLContext", (Throwable)e);
            }
            catch (CertificateException e) {
                LOGGER.error("Failed to create SSLContext", (Throwable)e);
                throw new RuntimeException("Failed to create SSLContext", e);
            }
        }
    }

    private static int initValueIndex() {
        Random r = new Random();
        return r.nextInt(999);
    }

    private void loadSocksProxyJson() {
        Map sockProxyMap = (Map)JSON.parseObject((String)this.nettyClientConfig.getSocksProxyConfig(), (TypeReference)new TypeReference<Map<String, SocksProxyConfig>>(){}, (Feature[])new Feature[0]);
        if (sockProxyMap != null) {
            this.proxyMap.putAll(sockProxyMap);
        }
    }

    @Override
    public void start() {
        if (this.defaultEventExecutorGroup == null) {
            this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
                private AtomicInteger threadIndex = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
                }
            });
        }
        Bootstrap handler = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyRemotingClient.this.nettyClientConfig.isUseTLS()) {
                    if (null != NettyRemotingClient.this.sslContext) {
                        pipeline.addFirst(NettyRemotingClient.this.defaultEventExecutorGroup, "sslHandler", (ChannelHandler)NettyRemotingClient.this.sslContext.newHandler(ch.alloc()));
                        LOGGER.info("Prepend SSL handler");
                    } else {
                        LOGGER.warn("Connections are insecure as SSLContext is null!");
                    }
                }
                ch.pipeline().addLast(NettyRemotingClient.this.nettyClientConfig.isDisableNettyWorkerGroup() ? null : NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
        if (this.nettyClientConfig.getClientSocketSndBufSize() > 0) {
            LOGGER.info("client set SO_SNDBUF to {}", (Object)this.nettyClientConfig.getClientSocketSndBufSize());
            handler.option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize());
        }
        if (this.nettyClientConfig.getClientSocketRcvBufSize() > 0) {
            LOGGER.info("client set SO_RCVBUF to {}", (Object)this.nettyClientConfig.getClientSocketRcvBufSize());
            handler.option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize());
        }
        if (this.nettyClientConfig.getWriteBufferLowWaterMark() > 0 && this.nettyClientConfig.getWriteBufferHighWaterMark() > 0) {
            LOGGER.info("client set netty WRITE_BUFFER_WATER_MARK to {},{}", (Object)this.nettyClientConfig.getWriteBufferLowWaterMark(), (Object)this.nettyClientConfig.getWriteBufferHighWaterMark());
            handler.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyClientConfig.getWriteBufferLowWaterMark(), this.nettyClientConfig.getWriteBufferHighWaterMark()));
        }
        if (this.nettyClientConfig.isClientPooledByteBufAllocatorEnable()) {
            handler.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingClient.this.scanResponseTable();
                }
                catch (Throwable e) {
                    LOGGER.error("scanResponseTable exception", e);
                }
            }
        }, 3000L, 1000L);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingClient.this.scanAvailableNameSrv();
                }
                catch (Exception e) {
                    LOGGER.error("scanAvailableNameSrv exception", (Throwable)e);
                }
            }
        }, 0L, (long)this.nettyClientConfig.getConnectTimeoutMillis());
    }

    private Map.Entry<String, SocksProxyConfig> getProxy(String addr) {
        if (StringUtils.isBlank((CharSequence)addr) || !addr.contains(":")) {
            return null;
        }
        String[] hostAndPort = this.getHostAndPort(addr);
        for (Map.Entry<String, SocksProxyConfig> entry : this.proxyMap.entrySet()) {
            String cidr = entry.getKey();
            if (!"0.0.0.0/0".equals(cidr) && !RemotingHelper.ipInCIDR(hostAndPort[0], cidr)) continue;
            return entry;
        }
        return null;
    }

    private Bootstrap fetchBootstrap(String addr) {
        Bootstrap old;
        Map.Entry<String, SocksProxyConfig> proxyEntry = this.getProxy(addr);
        if (proxyEntry == null) {
            return this.bootstrap;
        }
        String cidr = proxyEntry.getKey();
        SocksProxyConfig socksProxyConfig = proxyEntry.getValue();
        LOGGER.info("Netty fetch bootstrap, addr: {}, cidr: {}, proxy: {}", new Object[]{addr, cidr, socksProxyConfig != null ? socksProxyConfig.getAddr() : ""});
        Bootstrap bootstrapWithProxy = this.bootstrapMap.get(cidr);
        if (bootstrapWithProxy == null && (old = this.bootstrapMap.putIfAbsent(cidr, bootstrapWithProxy = this.createBootstrap(socksProxyConfig))) != null) {
            bootstrapWithProxy = old;
        }
        return bootstrapWithProxy;
    }

    private Bootstrap createBootstrap(final SocksProxyConfig proxy) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyRemotingClient.this.nettyClientConfig.isUseTLS()) {
                    if (null != NettyRemotingClient.this.sslContext) {
                        pipeline.addFirst(NettyRemotingClient.this.defaultEventExecutorGroup, "sslHandler", (ChannelHandler)NettyRemotingClient.this.sslContext.newHandler(ch.alloc()));
                        LOGGER.info("Prepend SSL handler");
                    } else {
                        LOGGER.warn("Connections are insecure as SSLContext is null!");
                    }
                }
                if (proxy != null) {
                    String[] hostAndPort = NettyRemotingClient.this.getHostAndPort(proxy.getAddr());
                    pipeline.addFirst(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])), proxy.getUsername(), proxy.getPassword())});
                }
                pipeline.addLast(NettyRemotingClient.this.nettyClientConfig.isDisableNettyWorkerGroup() ? null : NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
        if (proxy != null) {
            bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        return bootstrap;
    }

    private String[] getHostAndPort(String address) {
        return address.split(":");
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (String addr : this.channelTables.keySet()) {
                this.closeChannel(addr, ((ChannelWrapper)this.channelTables.get(addr)).getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            LOGGER.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
        if (this.scanExecutor != null) {
            try {
                this.scanExecutor.shutdown();
            }
            catch (Exception e) {
                LOGGER.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr(channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = (ChannelWrapper)this.channelTables.get(addrRemote);
                        LOGGER.info("closeChannel: begin close the channel[{}] Found: {}", (Object)addrRemote, (Object)(prevCW != null ? 1 : 0));
                        if (null == prevCW) {
                            LOGGER.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)addrRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            LOGGER.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            LOGGER.info("closeChannel: the channel[{}] was removed from channel table", (Object)addrRemote);
                        }
                        RemotingHelper.closeChannel(channel);
                        break block13;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (Map.Entry entry : this.channelTables.entrySet()) {
                            String key = (String)entry.getKey();
                            ChannelWrapper prev = (ChannelWrapper)entry.getValue();
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            LOGGER.info("eventCloseChannel: the channel[{}] has been removed from the channel table before", addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            LOGGER.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                            RemotingHelper.closeChannel(channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        LOGGER.error("closeChannel: close the channel exception", (Throwable)e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                LOGGER.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    @Override
    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (String addr : addrs) {
                    if (old.contains(addr)) continue;
                    update = true;
                    break;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                LOGGER.info("name server address updated. NEW : {} , OLD: {}", addrs, old);
                this.namesrvAddrList.set(addrs);
                if (this.namesrvAddrChoosed.get() != null && !addrs.contains(this.namesrvAddrChoosed.get())) {
                    String namesrvAddr = this.namesrvAddrChoosed.get();
                    for (String addr : this.channelTables.keySet()) {
                        ChannelWrapper channelWrapper;
                        if (!addr.contains(namesrvAddr) || (channelWrapper = (ChannelWrapper)this.channelTables.get(addr)) == null) continue;
                        this.closeChannel(channelWrapper.getChannel());
                    }
                }
            }
        }
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        long beginStartTime = System.currentTimeMillis();
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRpcHooks(addr, request);
                long costTime = System.currentTimeMillis() - beginStartTime;
                if (timeoutMillis < costTime) {
                    throw new RemotingTimeoutException("invokeSync call the addr[" + addr + "] timeout");
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis - costTime);
                this.doAfterRpcHooks(RemotingHelper.parseChannelRemoteAddr(channel), request, response);
                this.updateChannelLastResponseTime(addr);
                return response;
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeSync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                if (this.nettyClientConfig.isClientCloseSocketIfTimeout()) {
                    this.closeChannel(addr, channel);
                    LOGGER.warn("invokeSync: close socket because of timeout, {}ms, {}", (Object)timeoutMillis, (Object)addr);
                }
                LOGGER.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)addr);
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    @Override
    public void closeChannels(List<String> addrList) {
        for (String addr : addrList) {
            ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
            if (cw == null) continue;
            this.closeChannel(addr, cw.getChannel());
        }
        this.interruptPullRequests(new HashSet<String>(addrList));
    }

    private void interruptPullRequests(Set<String> brokerAddrSet) {
        for (ResponseFuture responseFuture : this.responseTable.values()) {
            String remoteAddr;
            RemotingCommand cmd = responseFuture.getRequestCommand();
            if (cmd == null || !brokerAddrSet.contains(remoteAddr = RemotingHelper.parseChannelRemoteAddr(responseFuture.getChannel())) || cmd.getCode() != 11 && cmd.getCode() != 361) continue;
            LOGGER.info("interrupt {}", (Object)cmd);
            responseFuture.interrupt();
        }
    }

    private void updateChannelLastResponseTime(String addr) {
        String address = addr;
        if (address == null) {
            address = this.namesrvAddrChoosed.get();
        }
        if (address == null) {
            LOGGER.warn("[updateChannelLastResponseTime] could not find address!!");
            return;
        }
        ChannelWrapper channelWrapper = (ChannelWrapper)this.channelTables.get(address);
        if (channelWrapper != null && channelWrapper.isOK()) {
            channelWrapper.updateLastResponseTime();
        }
    }

    private Channel getAndCreateChannel(String addr) throws InterruptedException {
        if (null == addr) {
            return this.getAndCreateNameserverChannel();
        }
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getAndCreateNameserverChannel() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = (ChannelWrapper)this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannel();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.namesrvChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = (ChannelWrapper)this.channelTables.get(addr)) != null && cw2.isOK()) {
                    Channel channel = cw2.getChannel();
                    return channel;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                for (int i = 0; i < addrList.size(); ++i) {
                    int index = this.namesrvIndex.incrementAndGet();
                    index = Math.abs(index);
                    String newAddr = addrList.get(index %= addrList.size());
                    this.namesrvAddrChoosed.set(newAddr);
                    LOGGER.info("new name server is chosen. OLD: {} , NEW: {}. namesrvIndex = {}", new Object[]{addr, newAddr, this.namesrvIndex});
                    Channel channelNew = this.createChannel(newAddr);
                    if (channelNew == null) continue;
                    Channel channel = channelNew;
                    return channel;
                }
                throw new RemotingConnectException(addrList.toString());
            }
            catch (Exception e) {
                LOGGER.error("getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.namesrvChannelLock.unlock();
            }
        } else {
            LOGGER.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr) throws InterruptedException {
        cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return ChannelWrapper.access$500(cw);
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                cw = (ChannelWrapper)this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        var4_3 = ChannelWrapper.access$500(cw);
                        return var4_3;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl34
                hostAndPort = this.getHostAndPort(addr);
                channelFuture = this.fetchBootstrap(addr).connect(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                NettyRemotingClient.LOGGER.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)addr);
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                NettyRemotingClient.LOGGER.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettyRemotingClient.LOGGER.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
lbl34:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly((long)this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    NettyRemotingClient.LOGGER.info("createChannel: connect remote host[{}] success, {}", (Object)addr, (Object)channelFuture.toString());
                    return ChannelWrapper.access$500(cw);
                }
                NettyRemotingClient.LOGGER.warn("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString());
            } else {
                NettyRemotingClient.LOGGER.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{addr, this.nettyClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        long beginStartTime = System.currentTimeMillis();
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRpcHooks(addr, request);
                long costTime = System.currentTimeMillis() - beginStartTime;
                if (timeoutMillis < costTime) {
                    throw new RemotingTooMuchRequestException("invokeAsync call the addr[" + addr + "] timeout");
                }
                this.invokeAsyncImpl(channel, request, timeoutMillis - costTime, new InvokeCallbackWrapper(invokeCallback, addr));
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRpcHooks(addr, request);
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                LOGGER.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public boolean isChannelWritable(String addr) {
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWritable();
        }
        return true;
    }

    @Override
    public boolean isAddressReachable(String addr) {
        if (addr == null || addr.isEmpty()) {
            return false;
        }
        try {
            Channel channel = this.getAndCreateChannel(addr);
            return channel != null && channel.isActive();
        }
        catch (Exception e) {
            LOGGER.warn("Get and create channel of {} failed", (Object)addr, (Object)e);
            return false;
        }
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    @Override
    public List<String> getAvailableNameSrvList() {
        return new ArrayList<String>(this.availableNamesrvAddrMap.keySet());
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        if (this.nettyClientConfig.isDisableCallbackExecutor()) {
            return null;
        }
        return this.callbackExecutor != null ? this.callbackExecutor : this.publicExecutor;
    }

    @Override
    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
    }

    protected void scanChannelTablesOfNameServer() {
        List<String> nameServerList = this.namesrvAddrList.get();
        if (nameServerList == null) {
            LOGGER.warn("[SCAN] Addresses of name server is empty!");
            return;
        }
        for (String addr : this.channelTables.keySet()) {
            ChannelWrapper channelWrapper = (ChannelWrapper)this.channelTables.get(addr);
            if (channelWrapper == null || System.currentTimeMillis() - channelWrapper.getLastResponseTime() <= this.nettyClientConfig.getChannelNotActiveInterval()) continue;
            LOGGER.warn("[SCAN] No response after {} from name server {}, so close it!", (Object)channelWrapper.getLastResponseTime(), (Object)addr);
            this.closeChannel(addr, channelWrapper.getChannel());
        }
    }

    private void scanAvailableNameSrv() {
        List<String> nameServerList = this.namesrvAddrList.get();
        if (nameServerList == null) {
            LOGGER.debug("scanAvailableNameSrv addresses of name server is null!");
            return;
        }
        for (String address : this.availableNamesrvAddrMap.keySet()) {
            if (nameServerList.contains(address)) continue;
            LOGGER.warn("scanAvailableNameSrv remove invalid address {}", (Object)address);
            this.availableNamesrvAddrMap.remove(address);
        }
        for (final String namesrvAddr : nameServerList) {
            this.scanExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Channel channel = NettyRemotingClient.this.getAndCreateChannel(namesrvAddr);
                        if (channel != null) {
                            NettyRemotingClient.this.availableNamesrvAddrMap.putIfAbsent(namesrvAddr, true);
                        } else {
                            Boolean value = (Boolean)NettyRemotingClient.this.availableNamesrvAddrMap.remove(namesrvAddr);
                            if (value != null) {
                                LOGGER.warn("scanAvailableNameSrv remove unconnected address {}", (Object)namesrvAddr);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("scanAvailableNameSrv get channel of {} failed, ", (Object)namesrvAddr, (Object)e);
                    }
                }
            });
        }
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOWN" : RemotingHelper.parseSocketAddressAddr(localAddress);
            String remote = remoteAddress == null ? "UNKNOWN" : RemotingHelper.parseSocketAddressAddr(remoteAddress);
            LOGGER.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remote, ctx.channel()));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.info("NETTY CLIENT PIPELINE: CLOSE {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            NettyRemotingClient.this.failFast(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                LOGGER.warn("NETTY CLIENT PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                NettyRemotingClient.this.closeChannel(ctx.channel());
                if (NettyRemotingClient.this.channelEventListener != null) {
                    NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress, ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            LOGGER.warn("NETTY CLIENT PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            LOGGER.warn("NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress, ctx.channel()));
            }
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    class InvokeCallbackWrapper
    implements InvokeCallback {
        private final InvokeCallback invokeCallback;
        private final String addr;

        public InvokeCallbackWrapper(InvokeCallback invokeCallback, String addr) {
            this.invokeCallback = invokeCallback;
            this.addr = addr;
        }

        @Override
        public void operationComplete(ResponseFuture responseFuture) {
            if (responseFuture != null && responseFuture.isSendRequestOK() && responseFuture.getResponseCommand() != null) {
                NettyRemotingClient.this.updateChannelLastResponseTime(this.addr);
            }
            this.invokeCallback.operationComplete(responseFuture);
        }
    }

    static class ChannelWrapper {
        private final ChannelFuture channelFuture;
        private long lastResponseTime;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
            this.lastResponseTime = System.currentTimeMillis();
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        public boolean isWritable() {
            return this.channelFuture.channel().isWritable();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        public long getLastResponseTime() {
            return this.lastResponseTime;
        }

        public void updateLastResponseTime() {
            this.lastResponseTime = System.currentTimeMillis();
        }
    }
}

